<?php

namespace App\Api\Client\Magento\Type\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Call ServiceType
 * @subpackage Services
 */
class Call extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named call
     * Meta informations extracted from the WSDL
     * - documentation: Call api functionality
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CallParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CallResponseParam|bool
     */
    public function call(\App\Api\Client\Magento\Type\StructType\CallParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->call($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Api\Client\Magento\Type\StructType\CallResponseParam
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
