<?php

namespace App\Api\Client\Magento\Type\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for shoppingCartProductResponseEntityArray ArrayType
 * @subpackage Arrays
 */
class ShoppingCartProductResponseEntityArray extends AbstractStructArrayBase
{
    /**
     * The complexObjectArray
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\StructType\CatalogProductEntity[]
     */
    public $complexObjectArray;
    /**
     * Constructor method for shoppingCartProductResponseEntityArray
     * @uses ShoppingCartProductResponseEntityArray::setComplexObjectArray()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductEntity[] $complexObjectArray
     */
    public function __construct(array $complexObjectArray = array())
    {
        $this
            ->setComplexObjectArray($complexObjectArray);
    }
    /**
     * Get complexObjectArray value
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductEntity[]|null
     */
    public function getComplexObjectArray()
    {
        return $this->complexObjectArray;
    }
    /**
     * Set complexObjectArray value
     * @throws \InvalidArgumentException
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductEntity[] $complexObjectArray
     * @return \App\Api\Client\Magento\Type\ArrayType\ShoppingCartProductResponseEntityArray
     */
    public function setComplexObjectArray(array $complexObjectArray = array())
    {
        foreach ($complexObjectArray as $shoppingCartProductResponseEntityArrayComplexObjectArrayItem) {
            // validation for constraint: itemType
            if (!$shoppingCartProductResponseEntityArrayComplexObjectArrayItem instanceof \App\Api\Client\Magento\Type\StructType\CatalogProductEntity) {
                throw new \InvalidArgumentException(sprintf('The complexObjectArray property can only contain items of \App\Api\Client\Magento\Type\StructType\CatalogProductEntity, "%s" given', is_object($shoppingCartProductResponseEntityArrayComplexObjectArrayItem) ? get_class($shoppingCartProductResponseEntityArrayComplexObjectArrayItem) : gettype($shoppingCartProductResponseEntityArrayComplexObjectArrayItem)), __LINE__);
            }
        }
        $this->complexObjectArray = $complexObjectArray;
        return $this;
    }
    /**
     * Add item to complexObjectArray value
     * @throws \InvalidArgumentException
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductEntity $item
     * @return \App\Api\Client\Magento\Type\ArrayType\ShoppingCartProductResponseEntityArray
     */
    public function addToComplexObjectArray(\App\Api\Client\Magento\Type\StructType\CatalogProductEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Api\Client\Magento\Type\StructType\CatalogProductEntity) {
            throw new \InvalidArgumentException(sprintf('The complexObjectArray property can only contain items of \App\Api\Client\Magento\Type\StructType\CatalogProductEntity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->complexObjectArray[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string complexObjectArray
     */
    public function getAttributeName()
    {
        return 'complexObjectArray';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\ArrayType\ShoppingCartProductResponseEntityArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
