<?php

namespace App\Api\Client\Magento\Type\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString ArrayType
 * @subpackage Arrays
 */
class ArrayOfString extends AbstractStructArrayBase
{
    /**
     * The complexObjectArray
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $complexObjectArray;
    /**
     * Constructor method for ArrayOfString
     * @uses ArrayOfString::setComplexObjectArray()
     * @param string[] $complexObjectArray
     */
    public function __construct(array $complexObjectArray = array())
    {
        $this
            ->setComplexObjectArray($complexObjectArray);
    }
    /**
     * Get complexObjectArray value
     * @return string[]|null
     */
    public function getComplexObjectArray()
    {
        return $this->complexObjectArray;
    }
    /**
     * Set complexObjectArray value
     * @throws \InvalidArgumentException
     * @param string[] $complexObjectArray
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public function setComplexObjectArray(array $complexObjectArray = array())
    {
        foreach ($complexObjectArray as $arrayOfStringComplexObjectArrayItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfStringComplexObjectArrayItem)) {
                throw new \InvalidArgumentException(sprintf('The complexObjectArray property can only contain items of string, "%s" given', is_object($arrayOfStringComplexObjectArrayItem) ? get_class($arrayOfStringComplexObjectArrayItem) : gettype($arrayOfStringComplexObjectArrayItem)), __LINE__);
            }
        }
        $this->complexObjectArray = $complexObjectArray;
        return $this;
    }
    /**
     * Add item to complexObjectArray value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public function addToComplexObjectArray($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The complexObjectArray property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->complexObjectArray[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string complexObjectArray
     */
    public function getAttributeName()
    {
        return 'complexObjectArray';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
