<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \App\Api\Client\Magento\Type\ClassMap::get(),
);
/**
 * Samples for Call ServiceType
 */
$call = new \App\Api\Client\Magento\Type\ServiceType\Call($options);
/**
 * Sample call for call operation/method
 */
if ($call->call(new \App\Api\Client\Magento\Type\StructType\CallParam()) !== false) {
    print_r($call->getResult());
} else {
    print_r($call->getLastError());
}
/**
 * Samples for Multi ServiceType
 */
$multi = new \App\Api\Client\Magento\Type\ServiceType\Multi($options);
/**
 * Sample call for multiCall operation/method
 */
if ($multi->multiCall(new \App\Api\Client\Magento\Type\StructType\MultiCallParam()) !== false) {
    print_r($multi->getResult());
} else {
    print_r($multi->getLastError());
}
/**
 * Samples for End ServiceType
 */
$end = new \App\Api\Client\Magento\Type\ServiceType\End($options);
/**
 * Sample call for endSession operation/method
 */
if ($end->endSession(new \App\Api\Client\Magento\Type\StructType\EndSessionParam()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \App\Api\Client\Magento\Type\ServiceType\Login($options);
/**
 * Sample call for login operation/method
 */
if ($login->login(new \App\Api\Client\Magento\Type\StructType\LoginParam()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Start ServiceType
 */
$start = new \App\Api\Client\Magento\Type\ServiceType\Start($options);
/**
 * Sample call for startSession operation/method
 */
if ($start->startSession() !== false) {
    print_r($start->getResult());
} else {
    print_r($start->getLastError());
}
/**
 * Samples for Resources ServiceType
 */
$resources = new \App\Api\Client\Magento\Type\ServiceType\Resources($options);
/**
 * Sample call for resources operation/method
 */
if ($resources->resources(new \App\Api\Client\Magento\Type\StructType\ResourcesRequestParam()) !== false) {
    print_r($resources->getResult());
} else {
    print_r($resources->getLastError());
}
/**
 * Samples for Global ServiceType
 */
$global = new \App\Api\Client\Magento\Type\ServiceType\_Global($options);
/**
 * Sample call for globalFaults operation/method
 */
if ($global->globalFaults(new \App\Api\Client\Magento\Type\StructType\GlobalFaultsParam()) !== false) {
    print_r($global->getResult());
} else {
    print_r($global->getLastError());
}
/**
 * Samples for Resource ServiceType
 */
$resource = new \App\Api\Client\Magento\Type\ServiceType\Resource($options);
/**
 * Sample call for resourceFaults operation/method
 */
if ($resource->resourceFaults(new \App\Api\Client\Magento\Type\StructType\ResourceFaultsParam()) !== false) {
    print_r($resource->getResult());
} else {
    print_r($resource->getLastError());
}
/**
 * Samples for Store ServiceType
 */
$store = new \App\Api\Client\Magento\Type\ServiceType\Store($options);
/**
 * Sample call for storeList operation/method
 */
if ($store->storeList(new \App\Api\Client\Magento\Type\StructType\StoreListRequestParam()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for storeInfo operation/method
 */
if ($store->storeInfo(new \App\Api\Client\Magento\Type\StructType\StoreInfoRequestParam()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Samples for Magento ServiceType
 */
$magento = new \App\Api\Client\Magento\Type\ServiceType\Magento($options);
/**
 * Sample call for magentoInfo operation/method
 */
if ($magento->magentoInfo(new \App\Api\Client\Magento\Type\StructType\MagentoInfoRequestParam()) !== false) {
    print_r($magento->getResult());
} else {
    print_r($magento->getLastError());
}
/**
 * Samples for Directory ServiceType
 */
$directory = new \App\Api\Client\Magento\Type\ServiceType\Directory($options);
/**
 * Sample call for directoryCountryList operation/method
 */
if ($directory->directoryCountryList(new \App\Api\Client\Magento\Type\StructType\DirectoryCountryListRequestParam()) !== false) {
    print_r($directory->getResult());
} else {
    print_r($directory->getLastError());
}
/**
 * Sample call for directoryRegionList operation/method
 */
if ($directory->directoryRegionList(new \App\Api\Client\Magento\Type\StructType\DirectoryRegionListRequestParam()) !== false) {
    print_r($directory->getResult());
} else {
    print_r($directory->getLastError());
}
/**
 * Samples for Customer ServiceType
 */
$customer = new \App\Api\Client\Magento\Type\ServiceType\Customer($options);
/**
 * Sample call for customerCustomerList operation/method
 */
if ($customer->customerCustomerList(new \App\Api\Client\Magento\Type\StructType\CustomerCustomerListRequestParam()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for customerCustomerCreate operation/method
 */
if ($customer->customerCustomerCreate(new \App\Api\Client\Magento\Type\StructType\CustomerCustomerCreateRequestParam()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for customerCustomerInfo operation/method
 */
if ($customer->customerCustomerInfo(new \App\Api\Client\Magento\Type\StructType\CustomerCustomerInfoRequestParam()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for customerCustomerUpdate operation/method
 */
if ($customer->customerCustomerUpdate(new \App\Api\Client\Magento\Type\StructType\CustomerCustomerUpdateRequestParam()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for customerCustomerDelete operation/method
 */
if ($customer->customerCustomerDelete(new \App\Api\Client\Magento\Type\StructType\CustomerCustomerDeleteRequestParam()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for customerGroupList operation/method
 */
if ($customer->customerGroupList(new \App\Api\Client\Magento\Type\StructType\CustomerGroupListRequestParam()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for customerAddressList operation/method
 */
if ($customer->customerAddressList(new \App\Api\Client\Magento\Type\StructType\CustomerAddressListRequestParam()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for customerAddressCreate operation/method
 */
if ($customer->customerAddressCreate(new \App\Api\Client\Magento\Type\StructType\CustomerAddressCreateRequestParam()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for customerAddressInfo operation/method
 */
if ($customer->customerAddressInfo(new \App\Api\Client\Magento\Type\StructType\CustomerAddressInfoRequestParam()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for customerAddressUpdate operation/method
 */
if ($customer->customerAddressUpdate(new \App\Api\Client\Magento\Type\StructType\CustomerAddressUpdateRequestParam()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for customerAddressDelete operation/method
 */
if ($customer->customerAddressDelete(new \App\Api\Client\Magento\Type\StructType\CustomerAddressDeleteRequestParam()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Samples for Catalog ServiceType
 */
$catalog = new \App\Api\Client\Magento\Type\ServiceType\Catalog($options);
/**
 * Sample call for catalogCategoryCurrentStore operation/method
 */
if ($catalog->catalogCategoryCurrentStore(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryCurrentStoreRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogCategoryTree operation/method
 */
if ($catalog->catalogCategoryTree(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryTreeRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogCategoryLevel operation/method
 */
if ($catalog->catalogCategoryLevel(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryLevelRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogCategoryInfo operation/method
 */
if ($catalog->catalogCategoryInfo(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfoRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogCategoryCreate operation/method
 */
if ($catalog->catalogCategoryCreate(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryCreateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogCategoryUpdate operation/method
 */
if ($catalog->catalogCategoryUpdate(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogCategoryMove operation/method
 */
if ($catalog->catalogCategoryMove(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryMoveRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogCategoryDelete operation/method
 */
if ($catalog->catalogCategoryDelete(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryDeleteRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogCategoryAssignedProducts operation/method
 */
if ($catalog->catalogCategoryAssignedProducts(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryAssignedProductsRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogCategoryAssignProduct operation/method
 */
if ($catalog->catalogCategoryAssignProduct(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryAssignProductRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogCategoryUpdateProduct operation/method
 */
if ($catalog->catalogCategoryUpdateProduct(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateProductRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogCategoryRemoveProduct operation/method
 */
if ($catalog->catalogCategoryRemoveProduct(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryRemoveProductRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductCurrentStore operation/method
 */
if ($catalog->catalogProductCurrentStore(new \App\Api\Client\Magento\Type\StructType\CatalogProductCurrentStoreRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductList operation/method
 */
if ($catalog->catalogProductList(new \App\Api\Client\Magento\Type\StructType\CatalogProductListRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductInfo operation/method
 */
if ($catalog->catalogProductInfo(new \App\Api\Client\Magento\Type\StructType\CatalogProductInfoRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductCreate operation/method
 */
if ($catalog->catalogProductCreate(new \App\Api\Client\Magento\Type\StructType\CatalogProductCreateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductUpdate operation/method
 */
if ($catalog->catalogProductUpdate(new \App\Api\Client\Magento\Type\StructType\CatalogProductUpdateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductMultiUpdate operation/method
 */
if ($catalog->catalogProductMultiUpdate(new \App\Api\Client\Magento\Type\StructType\CatalogProductMultiUpdateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductSetSpecialPrice operation/method
 */
if ($catalog->catalogProductSetSpecialPrice(new \App\Api\Client\Magento\Type\StructType\CatalogProductSetSpecialPriceRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductGetSpecialPrice operation/method
 */
if ($catalog->catalogProductGetSpecialPrice(new \App\Api\Client\Magento\Type\StructType\CatalogProductGetSpecialPriceRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductDelete operation/method
 */
if ($catalog->catalogProductDelete(new \App\Api\Client\Magento\Type\StructType\CatalogProductDeleteRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeCurrentStore operation/method
 */
if ($catalog->catalogProductAttributeCurrentStore(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeCurrentStoreRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeList operation/method
 */
if ($catalog->catalogProductAttributeList(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeListRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeOptions operation/method
 */
if ($catalog->catalogProductAttributeOptions(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeOptionsRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductCustomOptionAdd operation/method
 */
if ($catalog->catalogProductCustomOptionAdd(new \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionAddRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductCustomOptionUpdate operation/method
 */
if ($catalog->catalogProductCustomOptionUpdate(new \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionUpdateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductCustomOptionTypes operation/method
 */
if ($catalog->catalogProductCustomOptionTypes(new \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionTypesRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductCustomOptionList operation/method
 */
if ($catalog->catalogProductCustomOptionList(new \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionListRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductCustomOptionInfo operation/method
 */
if ($catalog->catalogProductCustomOptionInfo(new \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionInfoRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductCustomOptionRemove operation/method
 */
if ($catalog->catalogProductCustomOptionRemove(new \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionRemoveRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductCustomOptionValueList operation/method
 */
if ($catalog->catalogProductCustomOptionValueList(new \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueListRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductCustomOptionValueInfo operation/method
 */
if ($catalog->catalogProductCustomOptionValueInfo(new \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueInfoRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductCustomOptionValueAdd operation/method
 */
if ($catalog->catalogProductCustomOptionValueAdd(new \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueAddRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductCustomOptionValueUpdate operation/method
 */
if ($catalog->catalogProductCustomOptionValueUpdate(new \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueUpdateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductCustomOptionValueRemove operation/method
 */
if ($catalog->catalogProductCustomOptionValueRemove(new \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueRemoveRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeSetCreate operation/method
 */
if ($catalog->catalogProductAttributeSetCreate(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetCreateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeSetRemove operation/method
 */
if ($catalog->catalogProductAttributeSetRemove(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetRemoveRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeSetList operation/method
 */
if ($catalog->catalogProductAttributeSetList(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetListRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeSetAttributeAdd operation/method
 */
if ($catalog->catalogProductAttributeSetAttributeAdd(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeAddRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeSetAttributeRemove operation/method
 */
if ($catalog->catalogProductAttributeSetAttributeRemove(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeRemoveRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeAddOption operation/method
 */
if ($catalog->catalogProductAttributeAddOption(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeAddOptionRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeSetGroupAdd operation/method
 */
if ($catalog->catalogProductAttributeSetGroupAdd(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupAddRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeSetGroupRename operation/method
 */
if ($catalog->catalogProductAttributeSetGroupRename(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRenameRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeSetGroupRemove operation/method
 */
if ($catalog->catalogProductAttributeSetGroupRemove(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRemoveRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductTypeList operation/method
 */
if ($catalog->catalogProductTypeList(new \App\Api\Client\Magento\Type\StructType\CatalogProductTypeListRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeTierPriceInfo operation/method
 */
if ($catalog->catalogProductAttributeTierPriceInfo(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeTierPriceInfoRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeTierPriceUpdate operation/method
 */
if ($catalog->catalogProductAttributeTierPriceUpdate(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeTierPriceUpdateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogCategoryAttributeCurrentStore operation/method
 */
if ($catalog->catalogCategoryAttributeCurrentStore(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeCurrentStoreRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogCategoryAttributeList operation/method
 */
if ($catalog->catalogCategoryAttributeList(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeListRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogCategoryAttributeOptions operation/method
 */
if ($catalog->catalogCategoryAttributeOptions(new \App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeOptionsRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeMediaCurrentStore operation/method
 */
if ($catalog->catalogProductAttributeMediaCurrentStore(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaCurrentStoreRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeMediaList operation/method
 */
if ($catalog->catalogProductAttributeMediaList(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaListRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeMediaInfo operation/method
 */
if ($catalog->catalogProductAttributeMediaInfo(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaInfoRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeMediaTypes operation/method
 */
if ($catalog->catalogProductAttributeMediaTypes(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaTypesRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeMediaCreate operation/method
 */
if ($catalog->catalogProductAttributeMediaCreate(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaCreateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeMediaUpdate operation/method
 */
if ($catalog->catalogProductAttributeMediaUpdate(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaUpdateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeMediaRemove operation/method
 */
if ($catalog->catalogProductAttributeMediaRemove(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaRemoveRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductLinkList operation/method
 */
if ($catalog->catalogProductLinkList(new \App\Api\Client\Magento\Type\StructType\CatalogProductLinkListRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductLinkAssign operation/method
 */
if ($catalog->catalogProductLinkAssign(new \App\Api\Client\Magento\Type\StructType\CatalogProductLinkAssignRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductLinkUpdate operation/method
 */
if ($catalog->catalogProductLinkUpdate(new \App\Api\Client\Magento\Type\StructType\CatalogProductLinkUpdateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductLinkRemove operation/method
 */
if ($catalog->catalogProductLinkRemove(new \App\Api\Client\Magento\Type\StructType\CatalogProductLinkRemoveRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductLinkTypes operation/method
 */
if ($catalog->catalogProductLinkTypes(new \App\Api\Client\Magento\Type\StructType\CatalogProductLinkTypesRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductLinkAttributes operation/method
 */
if ($catalog->catalogProductLinkAttributes(new \App\Api\Client\Magento\Type\StructType\CatalogProductLinkAttributesRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeCreate operation/method
 */
if ($catalog->catalogProductAttributeCreate(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeCreateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeRemove operation/method
 */
if ($catalog->catalogProductAttributeRemove(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeRemoveRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeInfo operation/method
 */
if ($catalog->catalogProductAttributeInfo(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeInfoRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductAttributeUpdate operation/method
 */
if ($catalog->catalogProductAttributeUpdate(new \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeUpdateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogInventoryStockItemList operation/method
 */
if ($catalog->catalogInventoryStockItemList(new \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemListRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogInventoryStockItemUpdate operation/method
 */
if ($catalog->catalogInventoryStockItemUpdate(new \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogInventoryStockItemMultiUpdate operation/method
 */
if ($catalog->catalogInventoryStockItemMultiUpdate(new \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemMultiUpdateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductTagList operation/method
 */
if ($catalog->catalogProductTagList(new \App\Api\Client\Magento\Type\StructType\CatalogProductTagListRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductTagInfo operation/method
 */
if ($catalog->catalogProductTagInfo(new \App\Api\Client\Magento\Type\StructType\CatalogProductTagInfoRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductTagAdd operation/method
 */
if ($catalog->catalogProductTagAdd(new \App\Api\Client\Magento\Type\StructType\CatalogProductTagAddRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductTagUpdate operation/method
 */
if ($catalog->catalogProductTagUpdate(new \App\Api\Client\Magento\Type\StructType\CatalogProductTagUpdateRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductTagRemove operation/method
 */
if ($catalog->catalogProductTagRemove(new \App\Api\Client\Magento\Type\StructType\CatalogProductTagRemoveRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductDownloadableLinkAdd operation/method
 */
if ($catalog->catalogProductDownloadableLinkAdd(new \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductDownloadableLinkList operation/method
 */
if ($catalog->catalogProductDownloadableLinkList(new \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkListRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Sample call for catalogProductDownloadableLinkRemove operation/method
 */
if ($catalog->catalogProductDownloadableLinkRemove(new \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkRemoveRequestParam()) !== false) {
    print_r($catalog->getResult());
} else {
    print_r($catalog->getLastError());
}
/**
 * Samples for Sales ServiceType
 */
$sales = new \App\Api\Client\Magento\Type\ServiceType\Sales($options);
/**
 * Sample call for salesOrderList operation/method
 */
if ($sales->salesOrderList(new \App\Api\Client\Magento\Type\StructType\SalesOrderListRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderInfo operation/method
 */
if ($sales->salesOrderInfo(new \App\Api\Client\Magento\Type\StructType\SalesOrderInfoRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderAddComment operation/method
 */
if ($sales->salesOrderAddComment(new \App\Api\Client\Magento\Type\StructType\SalesOrderAddCommentRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderHold operation/method
 */
if ($sales->salesOrderHold(new \App\Api\Client\Magento\Type\StructType\SalesOrderHoldRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderUnhold operation/method
 */
if ($sales->salesOrderUnhold(new \App\Api\Client\Magento\Type\StructType\SalesOrderUnholdRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderCancel operation/method
 */
if ($sales->salesOrderCancel(new \App\Api\Client\Magento\Type\StructType\SalesOrderCancelRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderShipmentList operation/method
 */
if ($sales->salesOrderShipmentList(new \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentListRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderShipmentInfo operation/method
 */
if ($sales->salesOrderShipmentInfo(new \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentInfoRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderShipmentCreate operation/method
 */
if ($sales->salesOrderShipmentCreate(new \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentCreateRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderShipmentAddComment operation/method
 */
if ($sales->salesOrderShipmentAddComment(new \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddCommentRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderShipmentAddTrack operation/method
 */
if ($sales->salesOrderShipmentAddTrack(new \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddTrackRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderShipmentRemoveTrack operation/method
 */
if ($sales->salesOrderShipmentRemoveTrack(new \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentRemoveTrackRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderShipmentSendInfo operation/method
 */
if ($sales->salesOrderShipmentSendInfo(new \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentSendInfoRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderShipmentGetCarriers operation/method
 */
if ($sales->salesOrderShipmentGetCarriers(new \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentGetCarriersRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderInvoiceList operation/method
 */
if ($sales->salesOrderInvoiceList(new \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceListRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderInvoiceInfo operation/method
 */
if ($sales->salesOrderInvoiceInfo(new \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceInfoRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderInvoiceCreate operation/method
 */
if ($sales->salesOrderInvoiceCreate(new \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCreateRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderInvoiceAddComment operation/method
 */
if ($sales->salesOrderInvoiceAddComment(new \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceAddCommentRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderInvoiceCapture operation/method
 */
if ($sales->salesOrderInvoiceCapture(new \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCaptureRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderInvoiceVoid operation/method
 */
if ($sales->salesOrderInvoiceVoid(new \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceVoidRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderInvoiceCancel operation/method
 */
if ($sales->salesOrderInvoiceCancel(new \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCancelRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderCreditmemoList operation/method
 */
if ($sales->salesOrderCreditmemoList(new \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoListRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderCreditmemoInfo operation/method
 */
if ($sales->salesOrderCreditmemoInfo(new \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoInfoRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderCreditmemoCreate operation/method
 */
if ($sales->salesOrderCreditmemoCreate(new \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCreateRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderCreditmemoAddComment operation/method
 */
if ($sales->salesOrderCreditmemoAddComment(new \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoAddCommentRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Sample call for salesOrderCreditmemoCancel operation/method
 */
if ($sales->salesOrderCreditmemoCancel(new \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCancelRequestParam()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
/**
 * Samples for Shopping ServiceType
 */
$shopping = new \App\Api\Client\Magento\Type\ServiceType\Shopping($options);
/**
 * Sample call for shoppingCartCreate operation/method
 */
if ($shopping->shoppingCartCreate(new \App\Api\Client\Magento\Type\StructType\ShoppingCartCreateRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartInfo operation/method
 */
if ($shopping->shoppingCartInfo(new \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartTotals operation/method
 */
if ($shopping->shoppingCartTotals(new \App\Api\Client\Magento\Type\StructType\ShoppingCartTotalsRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartOrder operation/method
 */
if ($shopping->shoppingCartOrder(new \App\Api\Client\Magento\Type\StructType\ShoppingCartOrderRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartLicense operation/method
 */
if ($shopping->shoppingCartLicense(new \App\Api\Client\Magento\Type\StructType\ShoppingCartLicenseRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartProductAdd operation/method
 */
if ($shopping->shoppingCartProductAdd(new \App\Api\Client\Magento\Type\StructType\ShoppingCartProductAddRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartProductUpdate operation/method
 */
if ($shopping->shoppingCartProductUpdate(new \App\Api\Client\Magento\Type\StructType\ShoppingCartProductUpdateRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartProductRemove operation/method
 */
if ($shopping->shoppingCartProductRemove(new \App\Api\Client\Magento\Type\StructType\ShoppingCartProductRemoveRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartProductList operation/method
 */
if ($shopping->shoppingCartProductList(new \App\Api\Client\Magento\Type\StructType\ShoppingCartProductListRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartProductMoveToCustomerQuote operation/method
 */
if ($shopping->shoppingCartProductMoveToCustomerQuote(new \App\Api\Client\Magento\Type\StructType\ShoppingCartProductMoveToCustomerQuoteRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartCustomerSet operation/method
 */
if ($shopping->shoppingCartCustomerSet(new \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerSetRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartCustomerAddresses operation/method
 */
if ($shopping->shoppingCartCustomerAddresses(new \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressesRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartShippingMethod operation/method
 */
if ($shopping->shoppingCartShippingMethod(new \App\Api\Client\Magento\Type\StructType\ShoppingCartShippingMethodRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartShippingList operation/method
 */
if ($shopping->shoppingCartShippingList(new \App\Api\Client\Magento\Type\StructType\ShoppingCartShippingListRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartPaymentMethod operation/method
 */
if ($shopping->shoppingCartPaymentMethod(new \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartPaymentList operation/method
 */
if ($shopping->shoppingCartPaymentList(new \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentListRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartCouponAdd operation/method
 */
if ($shopping->shoppingCartCouponAdd(new \App\Api\Client\Magento\Type\StructType\ShoppingCartCouponAddRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for shoppingCartCouponRemove operation/method
 */
if ($shopping->shoppingCartCouponRemove(new \App\Api\Client\Magento\Type\StructType\ShoppingCartCouponRemoveRequestParam()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Samples for Gift ServiceType
 */
$gift = new \App\Api\Client\Magento\Type\ServiceType\Gift($options);
/**
 * Sample call for giftMessageSetForQuote operation/method
 */
if ($gift->giftMessageSetForQuote(new \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteRequestParam()) !== false) {
    print_r($gift->getResult());
} else {
    print_r($gift->getLastError());
}
/**
 * Sample call for giftMessageSetForQuoteItem operation/method
 */
if ($gift->giftMessageSetForQuoteItem(new \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteItemRequestParam()) !== false) {
    print_r($gift->getResult());
} else {
    print_r($gift->getLastError());
}
/**
 * Sample call for giftMessageSetForQuoteProduct operation/method
 */
if ($gift->giftMessageSetForQuoteProduct(new \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteProductRequestParam()) !== false) {
    print_r($gift->getResult());
} else {
    print_r($gift->getLastError());
}
