<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storeEntity StructType
 * @subpackage Structs
 */
class StoreEntity extends AbstractStructBase
{
    /**
     * The store_id
     * @var int
     */
    public $store_id;
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The website_id
     * @var int
     */
    public $website_id;
    /**
     * The group_id
     * @var int
     */
    public $group_id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The sort_order
     * @var int
     */
    public $sort_order;
    /**
     * The is_active
     * @var int
     */
    public $is_active;
    /**
     * Constructor method for storeEntity
     * @uses StoreEntity::setStore_id()
     * @uses StoreEntity::setCode()
     * @uses StoreEntity::setWebsite_id()
     * @uses StoreEntity::setGroup_id()
     * @uses StoreEntity::setName()
     * @uses StoreEntity::setSort_order()
     * @uses StoreEntity::setIs_active()
     * @param int $store_id
     * @param string $code
     * @param int $website_id
     * @param int $group_id
     * @param string $name
     * @param int $sort_order
     * @param int $is_active
     */
    public function __construct($store_id = null, $code = null, $website_id = null, $group_id = null, $name = null, $sort_order = null, $is_active = null)
    {
        $this
            ->setStore_id($store_id)
            ->setCode($code)
            ->setWebsite_id($website_id)
            ->setGroup_id($group_id)
            ->setName($name)
            ->setSort_order($sort_order)
            ->setIs_active($is_active);
    }
    /**
     * Get store_id value
     * @return int|null
     */
    public function getStore_id()
    {
        return $this->store_id;
    }
    /**
     * Set store_id value
     * @param int $store_id
     * @return \App\Api\Client\Magento\Type\StructType\StoreEntity
     */
    public function setStore_id($store_id = null)
    {
        // validation for constraint: int
        if (!is_null($store_id) && !is_numeric($store_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($store_id)), __LINE__);
        }
        $this->store_id = $store_id;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \App\Api\Client\Magento\Type\StructType\StoreEntity
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get website_id value
     * @return int|null
     */
    public function getWebsite_id()
    {
        return $this->website_id;
    }
    /**
     * Set website_id value
     * @param int $website_id
     * @return \App\Api\Client\Magento\Type\StructType\StoreEntity
     */
    public function setWebsite_id($website_id = null)
    {
        // validation for constraint: int
        if (!is_null($website_id) && !is_numeric($website_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($website_id)), __LINE__);
        }
        $this->website_id = $website_id;
        return $this;
    }
    /**
     * Get group_id value
     * @return int|null
     */
    public function getGroup_id()
    {
        return $this->group_id;
    }
    /**
     * Set group_id value
     * @param int $group_id
     * @return \App\Api\Client\Magento\Type\StructType\StoreEntity
     */
    public function setGroup_id($group_id = null)
    {
        // validation for constraint: int
        if (!is_null($group_id) && !is_numeric($group_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($group_id)), __LINE__);
        }
        $this->group_id = $group_id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Api\Client\Magento\Type\StructType\StoreEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get sort_order value
     * @return int|null
     */
    public function getSort_order()
    {
        return $this->sort_order;
    }
    /**
     * Set sort_order value
     * @param int $sort_order
     * @return \App\Api\Client\Magento\Type\StructType\StoreEntity
     */
    public function setSort_order($sort_order = null)
    {
        // validation for constraint: int
        if (!is_null($sort_order) && !is_numeric($sort_order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sort_order)), __LINE__);
        }
        $this->sort_order = $sort_order;
        return $this;
    }
    /**
     * Get is_active value
     * @return int|null
     */
    public function getIs_active()
    {
        return $this->is_active;
    }
    /**
     * Set is_active value
     * @param int $is_active
     * @return \App\Api\Client\Magento\Type\StructType\StoreEntity
     */
    public function setIs_active($is_active = null)
    {
        // validation for constraint: int
        if (!is_null($is_active) && !is_numeric($is_active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_active)), __LINE__);
        }
        $this->is_active = $is_active;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\StoreEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
