<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shoppingCartPaymentMethodResponseEntity StructType
 * @subpackage Structs
 */
class ShoppingCartPaymentMethodResponseEntity extends AbstractStructBase
{
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The cc_types
     * @var \App\Api\Client\Magento\Type\ArrayType\AssociativeArray
     */
    public $cc_types;
    /**
     * Constructor method for shoppingCartPaymentMethodResponseEntity
     * @uses ShoppingCartPaymentMethodResponseEntity::setCode()
     * @uses ShoppingCartPaymentMethodResponseEntity::setTitle()
     * @uses ShoppingCartPaymentMethodResponseEntity::setCc_types()
     * @param string $code
     * @param string $title
     * @param \App\Api\Client\Magento\Type\ArrayType\AssociativeArray $cc_types
     */
    public function __construct($code = null, $title = null, \App\Api\Client\Magento\Type\ArrayType\AssociativeArray $cc_types = null)
    {
        $this
            ->setCode($code)
            ->setTitle($title)
            ->setCc_types($cc_types);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodResponseEntity
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodResponseEntity
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get cc_types value
     * @return \App\Api\Client\Magento\Type\ArrayType\AssociativeArray|null
     */
    public function getCc_types()
    {
        return $this->cc_types;
    }
    /**
     * Set cc_types value
     * @param \App\Api\Client\Magento\Type\ArrayType\AssociativeArray $cc_types
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodResponseEntity
     */
    public function setCc_types(\App\Api\Client\Magento\Type\ArrayType\AssociativeArray $cc_types = null)
    {
        $this->cc_types = $cc_types;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodResponseEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
