<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shoppingCartItemEntity StructType
 * @subpackage Structs
 */
class ShoppingCartItemEntity extends AbstractStructBase
{
    /**
     * The item_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $item_id;
    /**
     * The created_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $created_at;
    /**
     * The updated_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $updated_at;
    /**
     * The product_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $product_id;
    /**
     * The store_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $store_id;
    /**
     * The parent_item_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $parent_item_id;
    /**
     * The is_virtual
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_virtual;
    /**
     * The sku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sku;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The applied_rule_ids
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $applied_rule_ids;
    /**
     * The additional_data
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $additional_data;
    /**
     * The free_shipping
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $free_shipping;
    /**
     * The is_qty_decimal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $is_qty_decimal;
    /**
     * The no_discount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $no_discount;
    /**
     * The weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weight;
    /**
     * The qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $qty;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The base_price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_price;
    /**
     * The custom_price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $custom_price;
    /**
     * The discount_percent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discount_percent;
    /**
     * The discount_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discount_amount;
    /**
     * The base_discount_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_discount_amount;
    /**
     * The tax_percent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax_percent;
    /**
     * The tax_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax_amount;
    /**
     * The base_tax_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_tax_amount;
    /**
     * The row_total
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $row_total;
    /**
     * The base_row_total
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_row_total;
    /**
     * The row_total_with_discount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $row_total_with_discount;
    /**
     * The row_weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $row_weight;
    /**
     * The product_type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $product_type;
    /**
     * The base_tax_before_discount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_tax_before_discount;
    /**
     * The tax_before_discount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax_before_discount;
    /**
     * The original_custom_price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $original_custom_price;
    /**
     * The base_cost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_cost;
    /**
     * The price_incl_tax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price_incl_tax;
    /**
     * The base_price_incl_tax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_price_incl_tax;
    /**
     * The row_total_incl_tax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $row_total_incl_tax;
    /**
     * The base_row_total_incl_tax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_row_total_incl_tax;
    /**
     * The gift_message_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gift_message_id;
    /**
     * The gift_message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gift_message;
    /**
     * The gift_message_available
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gift_message_available;
    /**
     * The weee_tax_applied
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weee_tax_applied;
    /**
     * The weee_tax_applied_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weee_tax_applied_amount;
    /**
     * The weee_tax_applied_row_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weee_tax_applied_row_amount;
    /**
     * The base_weee_tax_applied_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_weee_tax_applied_amount;
    /**
     * The base_weee_tax_applied_row_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_weee_tax_applied_row_amount;
    /**
     * The weee_tax_disposition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weee_tax_disposition;
    /**
     * The weee_tax_row_disposition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weee_tax_row_disposition;
    /**
     * The base_weee_tax_disposition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_weee_tax_disposition;
    /**
     * The base_weee_tax_row_disposition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_weee_tax_row_disposition;
    /**
     * The tax_class_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tax_class_id;
    /**
     * Constructor method for shoppingCartItemEntity
     * @uses ShoppingCartItemEntity::setItem_id()
     * @uses ShoppingCartItemEntity::setCreated_at()
     * @uses ShoppingCartItemEntity::setUpdated_at()
     * @uses ShoppingCartItemEntity::setProduct_id()
     * @uses ShoppingCartItemEntity::setStore_id()
     * @uses ShoppingCartItemEntity::setParent_item_id()
     * @uses ShoppingCartItemEntity::setIs_virtual()
     * @uses ShoppingCartItemEntity::setSku()
     * @uses ShoppingCartItemEntity::setName()
     * @uses ShoppingCartItemEntity::setDescription()
     * @uses ShoppingCartItemEntity::setApplied_rule_ids()
     * @uses ShoppingCartItemEntity::setAdditional_data()
     * @uses ShoppingCartItemEntity::setFree_shipping()
     * @uses ShoppingCartItemEntity::setIs_qty_decimal()
     * @uses ShoppingCartItemEntity::setNo_discount()
     * @uses ShoppingCartItemEntity::setWeight()
     * @uses ShoppingCartItemEntity::setQty()
     * @uses ShoppingCartItemEntity::setPrice()
     * @uses ShoppingCartItemEntity::setBase_price()
     * @uses ShoppingCartItemEntity::setCustom_price()
     * @uses ShoppingCartItemEntity::setDiscount_percent()
     * @uses ShoppingCartItemEntity::setDiscount_amount()
     * @uses ShoppingCartItemEntity::setBase_discount_amount()
     * @uses ShoppingCartItemEntity::setTax_percent()
     * @uses ShoppingCartItemEntity::setTax_amount()
     * @uses ShoppingCartItemEntity::setBase_tax_amount()
     * @uses ShoppingCartItemEntity::setRow_total()
     * @uses ShoppingCartItemEntity::setBase_row_total()
     * @uses ShoppingCartItemEntity::setRow_total_with_discount()
     * @uses ShoppingCartItemEntity::setRow_weight()
     * @uses ShoppingCartItemEntity::setProduct_type()
     * @uses ShoppingCartItemEntity::setBase_tax_before_discount()
     * @uses ShoppingCartItemEntity::setTax_before_discount()
     * @uses ShoppingCartItemEntity::setOriginal_custom_price()
     * @uses ShoppingCartItemEntity::setBase_cost()
     * @uses ShoppingCartItemEntity::setPrice_incl_tax()
     * @uses ShoppingCartItemEntity::setBase_price_incl_tax()
     * @uses ShoppingCartItemEntity::setRow_total_incl_tax()
     * @uses ShoppingCartItemEntity::setBase_row_total_incl_tax()
     * @uses ShoppingCartItemEntity::setGift_message_id()
     * @uses ShoppingCartItemEntity::setGift_message()
     * @uses ShoppingCartItemEntity::setGift_message_available()
     * @uses ShoppingCartItemEntity::setWeee_tax_applied()
     * @uses ShoppingCartItemEntity::setWeee_tax_applied_amount()
     * @uses ShoppingCartItemEntity::setWeee_tax_applied_row_amount()
     * @uses ShoppingCartItemEntity::setBase_weee_tax_applied_amount()
     * @uses ShoppingCartItemEntity::setBase_weee_tax_applied_row_amount()
     * @uses ShoppingCartItemEntity::setWeee_tax_disposition()
     * @uses ShoppingCartItemEntity::setWeee_tax_row_disposition()
     * @uses ShoppingCartItemEntity::setBase_weee_tax_disposition()
     * @uses ShoppingCartItemEntity::setBase_weee_tax_row_disposition()
     * @uses ShoppingCartItemEntity::setTax_class_id()
     * @param string $item_id
     * @param string $created_at
     * @param string $updated_at
     * @param string $product_id
     * @param string $store_id
     * @param string $parent_item_id
     * @param int $is_virtual
     * @param string $sku
     * @param string $name
     * @param string $description
     * @param string $applied_rule_ids
     * @param string $additional_data
     * @param string $free_shipping
     * @param string $is_qty_decimal
     * @param string $no_discount
     * @param float $weight
     * @param float $qty
     * @param float $price
     * @param float $base_price
     * @param float $custom_price
     * @param float $discount_percent
     * @param float $discount_amount
     * @param float $base_discount_amount
     * @param float $tax_percent
     * @param float $tax_amount
     * @param float $base_tax_amount
     * @param float $row_total
     * @param float $base_row_total
     * @param float $row_total_with_discount
     * @param float $row_weight
     * @param string $product_type
     * @param float $base_tax_before_discount
     * @param float $tax_before_discount
     * @param float $original_custom_price
     * @param float $base_cost
     * @param float $price_incl_tax
     * @param float $base_price_incl_tax
     * @param float $row_total_incl_tax
     * @param float $base_row_total_incl_tax
     * @param string $gift_message_id
     * @param string $gift_message
     * @param string $gift_message_available
     * @param float $weee_tax_applied
     * @param float $weee_tax_applied_amount
     * @param float $weee_tax_applied_row_amount
     * @param float $base_weee_tax_applied_amount
     * @param float $base_weee_tax_applied_row_amount
     * @param float $weee_tax_disposition
     * @param float $weee_tax_row_disposition
     * @param float $base_weee_tax_disposition
     * @param float $base_weee_tax_row_disposition
     * @param string $tax_class_id
     */
    public function __construct($item_id = null, $created_at = null, $updated_at = null, $product_id = null, $store_id = null, $parent_item_id = null, $is_virtual = null, $sku = null, $name = null, $description = null, $applied_rule_ids = null, $additional_data = null, $free_shipping = null, $is_qty_decimal = null, $no_discount = null, $weight = null, $qty = null, $price = null, $base_price = null, $custom_price = null, $discount_percent = null, $discount_amount = null, $base_discount_amount = null, $tax_percent = null, $tax_amount = null, $base_tax_amount = null, $row_total = null, $base_row_total = null, $row_total_with_discount = null, $row_weight = null, $product_type = null, $base_tax_before_discount = null, $tax_before_discount = null, $original_custom_price = null, $base_cost = null, $price_incl_tax = null, $base_price_incl_tax = null, $row_total_incl_tax = null, $base_row_total_incl_tax = null, $gift_message_id = null, $gift_message = null, $gift_message_available = null, $weee_tax_applied = null, $weee_tax_applied_amount = null, $weee_tax_applied_row_amount = null, $base_weee_tax_applied_amount = null, $base_weee_tax_applied_row_amount = null, $weee_tax_disposition = null, $weee_tax_row_disposition = null, $base_weee_tax_disposition = null, $base_weee_tax_row_disposition = null, $tax_class_id = null)
    {
        $this
            ->setItem_id($item_id)
            ->setCreated_at($created_at)
            ->setUpdated_at($updated_at)
            ->setProduct_id($product_id)
            ->setStore_id($store_id)
            ->setParent_item_id($parent_item_id)
            ->setIs_virtual($is_virtual)
            ->setSku($sku)
            ->setName($name)
            ->setDescription($description)
            ->setApplied_rule_ids($applied_rule_ids)
            ->setAdditional_data($additional_data)
            ->setFree_shipping($free_shipping)
            ->setIs_qty_decimal($is_qty_decimal)
            ->setNo_discount($no_discount)
            ->setWeight($weight)
            ->setQty($qty)
            ->setPrice($price)
            ->setBase_price($base_price)
            ->setCustom_price($custom_price)
            ->setDiscount_percent($discount_percent)
            ->setDiscount_amount($discount_amount)
            ->setBase_discount_amount($base_discount_amount)
            ->setTax_percent($tax_percent)
            ->setTax_amount($tax_amount)
            ->setBase_tax_amount($base_tax_amount)
            ->setRow_total($row_total)
            ->setBase_row_total($base_row_total)
            ->setRow_total_with_discount($row_total_with_discount)
            ->setRow_weight($row_weight)
            ->setProduct_type($product_type)
            ->setBase_tax_before_discount($base_tax_before_discount)
            ->setTax_before_discount($tax_before_discount)
            ->setOriginal_custom_price($original_custom_price)
            ->setBase_cost($base_cost)
            ->setPrice_incl_tax($price_incl_tax)
            ->setBase_price_incl_tax($base_price_incl_tax)
            ->setRow_total_incl_tax($row_total_incl_tax)
            ->setBase_row_total_incl_tax($base_row_total_incl_tax)
            ->setGift_message_id($gift_message_id)
            ->setGift_message($gift_message)
            ->setGift_message_available($gift_message_available)
            ->setWeee_tax_applied($weee_tax_applied)
            ->setWeee_tax_applied_amount($weee_tax_applied_amount)
            ->setWeee_tax_applied_row_amount($weee_tax_applied_row_amount)
            ->setBase_weee_tax_applied_amount($base_weee_tax_applied_amount)
            ->setBase_weee_tax_applied_row_amount($base_weee_tax_applied_row_amount)
            ->setWeee_tax_disposition($weee_tax_disposition)
            ->setWeee_tax_row_disposition($weee_tax_row_disposition)
            ->setBase_weee_tax_disposition($base_weee_tax_disposition)
            ->setBase_weee_tax_row_disposition($base_weee_tax_row_disposition)
            ->setTax_class_id($tax_class_id);
    }
    /**
     * Get item_id value
     * @return string|null
     */
    public function getItem_id()
    {
        return $this->item_id;
    }
    /**
     * Set item_id value
     * @param string $item_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setItem_id($item_id = null)
    {
        // validation for constraint: string
        if (!is_null($item_id) && !is_string($item_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($item_id)), __LINE__);
        }
        $this->item_id = $item_id;
        return $this;
    }
    /**
     * Get created_at value
     * @return string|null
     */
    public function getCreated_at()
    {
        return $this->created_at;
    }
    /**
     * Set created_at value
     * @param string $created_at
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setCreated_at($created_at = null)
    {
        // validation for constraint: string
        if (!is_null($created_at) && !is_string($created_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created_at)), __LINE__);
        }
        $this->created_at = $created_at;
        return $this;
    }
    /**
     * Get updated_at value
     * @return string|null
     */
    public function getUpdated_at()
    {
        return $this->updated_at;
    }
    /**
     * Set updated_at value
     * @param string $updated_at
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setUpdated_at($updated_at = null)
    {
        // validation for constraint: string
        if (!is_null($updated_at) && !is_string($updated_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updated_at)), __LINE__);
        }
        $this->updated_at = $updated_at;
        return $this;
    }
    /**
     * Get product_id value
     * @return string|null
     */
    public function getProduct_id()
    {
        return $this->product_id;
    }
    /**
     * Set product_id value
     * @param string $product_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setProduct_id($product_id = null)
    {
        // validation for constraint: string
        if (!is_null($product_id) && !is_string($product_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product_id)), __LINE__);
        }
        $this->product_id = $product_id;
        return $this;
    }
    /**
     * Get store_id value
     * @return string|null
     */
    public function getStore_id()
    {
        return $this->store_id;
    }
    /**
     * Set store_id value
     * @param string $store_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setStore_id($store_id = null)
    {
        // validation for constraint: string
        if (!is_null($store_id) && !is_string($store_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store_id)), __LINE__);
        }
        $this->store_id = $store_id;
        return $this;
    }
    /**
     * Get parent_item_id value
     * @return string|null
     */
    public function getParent_item_id()
    {
        return $this->parent_item_id;
    }
    /**
     * Set parent_item_id value
     * @param string $parent_item_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setParent_item_id($parent_item_id = null)
    {
        // validation for constraint: string
        if (!is_null($parent_item_id) && !is_string($parent_item_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parent_item_id)), __LINE__);
        }
        $this->parent_item_id = $parent_item_id;
        return $this;
    }
    /**
     * Get is_virtual value
     * @return int|null
     */
    public function getIs_virtual()
    {
        return $this->is_virtual;
    }
    /**
     * Set is_virtual value
     * @param int $is_virtual
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setIs_virtual($is_virtual = null)
    {
        // validation for constraint: int
        if (!is_null($is_virtual) && !is_numeric($is_virtual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_virtual)), __LINE__);
        }
        $this->is_virtual = $is_virtual;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get applied_rule_ids value
     * @return string|null
     */
    public function getApplied_rule_ids()
    {
        return $this->applied_rule_ids;
    }
    /**
     * Set applied_rule_ids value
     * @param string $applied_rule_ids
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setApplied_rule_ids($applied_rule_ids = null)
    {
        // validation for constraint: string
        if (!is_null($applied_rule_ids) && !is_string($applied_rule_ids)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applied_rule_ids)), __LINE__);
        }
        $this->applied_rule_ids = $applied_rule_ids;
        return $this;
    }
    /**
     * Get additional_data value
     * @return string|null
     */
    public function getAdditional_data()
    {
        return $this->additional_data;
    }
    /**
     * Set additional_data value
     * @param string $additional_data
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setAdditional_data($additional_data = null)
    {
        // validation for constraint: string
        if (!is_null($additional_data) && !is_string($additional_data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($additional_data)), __LINE__);
        }
        $this->additional_data = $additional_data;
        return $this;
    }
    /**
     * Get free_shipping value
     * @return string|null
     */
    public function getFree_shipping()
    {
        return $this->free_shipping;
    }
    /**
     * Set free_shipping value
     * @param string $free_shipping
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setFree_shipping($free_shipping = null)
    {
        // validation for constraint: string
        if (!is_null($free_shipping) && !is_string($free_shipping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($free_shipping)), __LINE__);
        }
        $this->free_shipping = $free_shipping;
        return $this;
    }
    /**
     * Get is_qty_decimal value
     * @return string|null
     */
    public function getIs_qty_decimal()
    {
        return $this->is_qty_decimal;
    }
    /**
     * Set is_qty_decimal value
     * @param string $is_qty_decimal
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setIs_qty_decimal($is_qty_decimal = null)
    {
        // validation for constraint: string
        if (!is_null($is_qty_decimal) && !is_string($is_qty_decimal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($is_qty_decimal)), __LINE__);
        }
        $this->is_qty_decimal = $is_qty_decimal;
        return $this;
    }
    /**
     * Get no_discount value
     * @return string|null
     */
    public function getNo_discount()
    {
        return $this->no_discount;
    }
    /**
     * Set no_discount value
     * @param string $no_discount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setNo_discount($no_discount = null)
    {
        // validation for constraint: string
        if (!is_null($no_discount) && !is_string($no_discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($no_discount)), __LINE__);
        }
        $this->no_discount = $no_discount;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setWeight($weight = null)
    {
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get qty value
     * @return float|null
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param float $qty
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setQty($qty = null)
    {
        $this->qty = $qty;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setPrice($price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get base_price value
     * @return float|null
     */
    public function getBase_price()
    {
        return $this->base_price;
    }
    /**
     * Set base_price value
     * @param float $base_price
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setBase_price($base_price = null)
    {
        $this->base_price = $base_price;
        return $this;
    }
    /**
     * Get custom_price value
     * @return float|null
     */
    public function getCustom_price()
    {
        return $this->custom_price;
    }
    /**
     * Set custom_price value
     * @param float $custom_price
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setCustom_price($custom_price = null)
    {
        $this->custom_price = $custom_price;
        return $this;
    }
    /**
     * Get discount_percent value
     * @return float|null
     */
    public function getDiscount_percent()
    {
        return $this->discount_percent;
    }
    /**
     * Set discount_percent value
     * @param float $discount_percent
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setDiscount_percent($discount_percent = null)
    {
        $this->discount_percent = $discount_percent;
        return $this;
    }
    /**
     * Get discount_amount value
     * @return float|null
     */
    public function getDiscount_amount()
    {
        return $this->discount_amount;
    }
    /**
     * Set discount_amount value
     * @param float $discount_amount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setDiscount_amount($discount_amount = null)
    {
        $this->discount_amount = $discount_amount;
        return $this;
    }
    /**
     * Get base_discount_amount value
     * @return float|null
     */
    public function getBase_discount_amount()
    {
        return $this->base_discount_amount;
    }
    /**
     * Set base_discount_amount value
     * @param float $base_discount_amount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setBase_discount_amount($base_discount_amount = null)
    {
        $this->base_discount_amount = $base_discount_amount;
        return $this;
    }
    /**
     * Get tax_percent value
     * @return float|null
     */
    public function getTax_percent()
    {
        return $this->tax_percent;
    }
    /**
     * Set tax_percent value
     * @param float $tax_percent
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setTax_percent($tax_percent = null)
    {
        $this->tax_percent = $tax_percent;
        return $this;
    }
    /**
     * Get tax_amount value
     * @return float|null
     */
    public function getTax_amount()
    {
        return $this->tax_amount;
    }
    /**
     * Set tax_amount value
     * @param float $tax_amount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setTax_amount($tax_amount = null)
    {
        $this->tax_amount = $tax_amount;
        return $this;
    }
    /**
     * Get base_tax_amount value
     * @return float|null
     */
    public function getBase_tax_amount()
    {
        return $this->base_tax_amount;
    }
    /**
     * Set base_tax_amount value
     * @param float $base_tax_amount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setBase_tax_amount($base_tax_amount = null)
    {
        $this->base_tax_amount = $base_tax_amount;
        return $this;
    }
    /**
     * Get row_total value
     * @return float|null
     */
    public function getRow_total()
    {
        return $this->row_total;
    }
    /**
     * Set row_total value
     * @param float $row_total
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setRow_total($row_total = null)
    {
        $this->row_total = $row_total;
        return $this;
    }
    /**
     * Get base_row_total value
     * @return float|null
     */
    public function getBase_row_total()
    {
        return $this->base_row_total;
    }
    /**
     * Set base_row_total value
     * @param float $base_row_total
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setBase_row_total($base_row_total = null)
    {
        $this->base_row_total = $base_row_total;
        return $this;
    }
    /**
     * Get row_total_with_discount value
     * @return float|null
     */
    public function getRow_total_with_discount()
    {
        return $this->row_total_with_discount;
    }
    /**
     * Set row_total_with_discount value
     * @param float $row_total_with_discount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setRow_total_with_discount($row_total_with_discount = null)
    {
        $this->row_total_with_discount = $row_total_with_discount;
        return $this;
    }
    /**
     * Get row_weight value
     * @return float|null
     */
    public function getRow_weight()
    {
        return $this->row_weight;
    }
    /**
     * Set row_weight value
     * @param float $row_weight
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setRow_weight($row_weight = null)
    {
        $this->row_weight = $row_weight;
        return $this;
    }
    /**
     * Get product_type value
     * @return string|null
     */
    public function getProduct_type()
    {
        return $this->product_type;
    }
    /**
     * Set product_type value
     * @param string $product_type
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setProduct_type($product_type = null)
    {
        // validation for constraint: string
        if (!is_null($product_type) && !is_string($product_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product_type)), __LINE__);
        }
        $this->product_type = $product_type;
        return $this;
    }
    /**
     * Get base_tax_before_discount value
     * @return float|null
     */
    public function getBase_tax_before_discount()
    {
        return $this->base_tax_before_discount;
    }
    /**
     * Set base_tax_before_discount value
     * @param float $base_tax_before_discount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setBase_tax_before_discount($base_tax_before_discount = null)
    {
        $this->base_tax_before_discount = $base_tax_before_discount;
        return $this;
    }
    /**
     * Get tax_before_discount value
     * @return float|null
     */
    public function getTax_before_discount()
    {
        return $this->tax_before_discount;
    }
    /**
     * Set tax_before_discount value
     * @param float $tax_before_discount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setTax_before_discount($tax_before_discount = null)
    {
        $this->tax_before_discount = $tax_before_discount;
        return $this;
    }
    /**
     * Get original_custom_price value
     * @return float|null
     */
    public function getOriginal_custom_price()
    {
        return $this->original_custom_price;
    }
    /**
     * Set original_custom_price value
     * @param float $original_custom_price
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setOriginal_custom_price($original_custom_price = null)
    {
        $this->original_custom_price = $original_custom_price;
        return $this;
    }
    /**
     * Get base_cost value
     * @return float|null
     */
    public function getBase_cost()
    {
        return $this->base_cost;
    }
    /**
     * Set base_cost value
     * @param float $base_cost
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setBase_cost($base_cost = null)
    {
        $this->base_cost = $base_cost;
        return $this;
    }
    /**
     * Get price_incl_tax value
     * @return float|null
     */
    public function getPrice_incl_tax()
    {
        return $this->price_incl_tax;
    }
    /**
     * Set price_incl_tax value
     * @param float $price_incl_tax
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setPrice_incl_tax($price_incl_tax = null)
    {
        $this->price_incl_tax = $price_incl_tax;
        return $this;
    }
    /**
     * Get base_price_incl_tax value
     * @return float|null
     */
    public function getBase_price_incl_tax()
    {
        return $this->base_price_incl_tax;
    }
    /**
     * Set base_price_incl_tax value
     * @param float $base_price_incl_tax
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setBase_price_incl_tax($base_price_incl_tax = null)
    {
        $this->base_price_incl_tax = $base_price_incl_tax;
        return $this;
    }
    /**
     * Get row_total_incl_tax value
     * @return float|null
     */
    public function getRow_total_incl_tax()
    {
        return $this->row_total_incl_tax;
    }
    /**
     * Set row_total_incl_tax value
     * @param float $row_total_incl_tax
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setRow_total_incl_tax($row_total_incl_tax = null)
    {
        $this->row_total_incl_tax = $row_total_incl_tax;
        return $this;
    }
    /**
     * Get base_row_total_incl_tax value
     * @return float|null
     */
    public function getBase_row_total_incl_tax()
    {
        return $this->base_row_total_incl_tax;
    }
    /**
     * Set base_row_total_incl_tax value
     * @param float $base_row_total_incl_tax
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setBase_row_total_incl_tax($base_row_total_incl_tax = null)
    {
        $this->base_row_total_incl_tax = $base_row_total_incl_tax;
        return $this;
    }
    /**
     * Get gift_message_id value
     * @return string|null
     */
    public function getGift_message_id()
    {
        return $this->gift_message_id;
    }
    /**
     * Set gift_message_id value
     * @param string $gift_message_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setGift_message_id($gift_message_id = null)
    {
        // validation for constraint: string
        if (!is_null($gift_message_id) && !is_string($gift_message_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gift_message_id)), __LINE__);
        }
        $this->gift_message_id = $gift_message_id;
        return $this;
    }
    /**
     * Get gift_message value
     * @return string|null
     */
    public function getGift_message()
    {
        return $this->gift_message;
    }
    /**
     * Set gift_message value
     * @param string $gift_message
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setGift_message($gift_message = null)
    {
        // validation for constraint: string
        if (!is_null($gift_message) && !is_string($gift_message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gift_message)), __LINE__);
        }
        $this->gift_message = $gift_message;
        return $this;
    }
    /**
     * Get gift_message_available value
     * @return string|null
     */
    public function getGift_message_available()
    {
        return $this->gift_message_available;
    }
    /**
     * Set gift_message_available value
     * @param string $gift_message_available
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setGift_message_available($gift_message_available = null)
    {
        // validation for constraint: string
        if (!is_null($gift_message_available) && !is_string($gift_message_available)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gift_message_available)), __LINE__);
        }
        $this->gift_message_available = $gift_message_available;
        return $this;
    }
    /**
     * Get weee_tax_applied value
     * @return float|null
     */
    public function getWeee_tax_applied()
    {
        return $this->weee_tax_applied;
    }
    /**
     * Set weee_tax_applied value
     * @param float $weee_tax_applied
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setWeee_tax_applied($weee_tax_applied = null)
    {
        $this->weee_tax_applied = $weee_tax_applied;
        return $this;
    }
    /**
     * Get weee_tax_applied_amount value
     * @return float|null
     */
    public function getWeee_tax_applied_amount()
    {
        return $this->weee_tax_applied_amount;
    }
    /**
     * Set weee_tax_applied_amount value
     * @param float $weee_tax_applied_amount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setWeee_tax_applied_amount($weee_tax_applied_amount = null)
    {
        $this->weee_tax_applied_amount = $weee_tax_applied_amount;
        return $this;
    }
    /**
     * Get weee_tax_applied_row_amount value
     * @return float|null
     */
    public function getWeee_tax_applied_row_amount()
    {
        return $this->weee_tax_applied_row_amount;
    }
    /**
     * Set weee_tax_applied_row_amount value
     * @param float $weee_tax_applied_row_amount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setWeee_tax_applied_row_amount($weee_tax_applied_row_amount = null)
    {
        $this->weee_tax_applied_row_amount = $weee_tax_applied_row_amount;
        return $this;
    }
    /**
     * Get base_weee_tax_applied_amount value
     * @return float|null
     */
    public function getBase_weee_tax_applied_amount()
    {
        return $this->base_weee_tax_applied_amount;
    }
    /**
     * Set base_weee_tax_applied_amount value
     * @param float $base_weee_tax_applied_amount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setBase_weee_tax_applied_amount($base_weee_tax_applied_amount = null)
    {
        $this->base_weee_tax_applied_amount = $base_weee_tax_applied_amount;
        return $this;
    }
    /**
     * Get base_weee_tax_applied_row_amount value
     * @return float|null
     */
    public function getBase_weee_tax_applied_row_amount()
    {
        return $this->base_weee_tax_applied_row_amount;
    }
    /**
     * Set base_weee_tax_applied_row_amount value
     * @param float $base_weee_tax_applied_row_amount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setBase_weee_tax_applied_row_amount($base_weee_tax_applied_row_amount = null)
    {
        $this->base_weee_tax_applied_row_amount = $base_weee_tax_applied_row_amount;
        return $this;
    }
    /**
     * Get weee_tax_disposition value
     * @return float|null
     */
    public function getWeee_tax_disposition()
    {
        return $this->weee_tax_disposition;
    }
    /**
     * Set weee_tax_disposition value
     * @param float $weee_tax_disposition
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setWeee_tax_disposition($weee_tax_disposition = null)
    {
        $this->weee_tax_disposition = $weee_tax_disposition;
        return $this;
    }
    /**
     * Get weee_tax_row_disposition value
     * @return float|null
     */
    public function getWeee_tax_row_disposition()
    {
        return $this->weee_tax_row_disposition;
    }
    /**
     * Set weee_tax_row_disposition value
     * @param float $weee_tax_row_disposition
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setWeee_tax_row_disposition($weee_tax_row_disposition = null)
    {
        $this->weee_tax_row_disposition = $weee_tax_row_disposition;
        return $this;
    }
    /**
     * Get base_weee_tax_disposition value
     * @return float|null
     */
    public function getBase_weee_tax_disposition()
    {
        return $this->base_weee_tax_disposition;
    }
    /**
     * Set base_weee_tax_disposition value
     * @param float $base_weee_tax_disposition
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setBase_weee_tax_disposition($base_weee_tax_disposition = null)
    {
        $this->base_weee_tax_disposition = $base_weee_tax_disposition;
        return $this;
    }
    /**
     * Get base_weee_tax_row_disposition value
     * @return float|null
     */
    public function getBase_weee_tax_row_disposition()
    {
        return $this->base_weee_tax_row_disposition;
    }
    /**
     * Set base_weee_tax_row_disposition value
     * @param float $base_weee_tax_row_disposition
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setBase_weee_tax_row_disposition($base_weee_tax_row_disposition = null)
    {
        $this->base_weee_tax_row_disposition = $base_weee_tax_row_disposition;
        return $this;
    }
    /**
     * Get tax_class_id value
     * @return string|null
     */
    public function getTax_class_id()
    {
        return $this->tax_class_id;
    }
    /**
     * Set tax_class_id value
     * @param string $tax_class_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public function setTax_class_id($tax_class_id = null)
    {
        // validation for constraint: string
        if (!is_null($tax_class_id) && !is_string($tax_class_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tax_class_id)), __LINE__);
        }
        $this->tax_class_id = $tax_class_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartItemEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
