<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shoppingCartCustomerSetRequestParam StructType
 * @subpackage Structs
 */
class ShoppingCartCustomerSetRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The quoteId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $quoteId;
    /**
     * The customerData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity
     */
    public $customerData;
    /**
     * The store
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $store;
    /**
     * Constructor method for shoppingCartCustomerSetRequestParam
     * @uses ShoppingCartCustomerSetRequestParam::setSessionId()
     * @uses ShoppingCartCustomerSetRequestParam::setQuoteId()
     * @uses ShoppingCartCustomerSetRequestParam::setCustomerData()
     * @uses ShoppingCartCustomerSetRequestParam::setStore()
     * @param string $sessionId
     * @param int $quoteId
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity $customerData
     * @param string $store
     */
    public function __construct($sessionId = null, $quoteId = null, \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity $customerData = null, $store = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setQuoteId($quoteId)
            ->setCustomerData($customerData)
            ->setStore($store);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerSetRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get quoteId value
     * @return int
     */
    public function getQuoteId()
    {
        return $this->quoteId;
    }
    /**
     * Set quoteId value
     * @param int $quoteId
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerSetRequestParam
     */
    public function setQuoteId($quoteId = null)
    {
        // validation for constraint: int
        if (!is_null($quoteId) && !is_numeric($quoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quoteId)), __LINE__);
        }
        $this->quoteId = $quoteId;
        return $this;
    }
    /**
     * Get customerData value
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity
     */
    public function getCustomerData()
    {
        return $this->customerData;
    }
    /**
     * Set customerData value
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity $customerData
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerSetRequestParam
     */
    public function setCustomerData(\App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity $customerData = null)
    {
        $this->customerData = $customerData;
        return $this;
    }
    /**
     * Get store value
     * @return string|null
     */
    public function getStore()
    {
        return $this->store;
    }
    /**
     * Set store value
     * @param string $store
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerSetRequestParam
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        $this->store = $store;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerSetRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
