<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shoppingCartAddressEntity StructType
 * @subpackage Structs
 */
class ShoppingCartAddressEntity extends AbstractStructBase
{
    /**
     * The address_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address_id;
    /**
     * The created_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $created_at;
    /**
     * The updated_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $updated_at;
    /**
     * The customer_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_id;
    /**
     * The save_in_address_book
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $save_in_address_book;
    /**
     * The customer_address_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_address_id;
    /**
     * The address_type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address_type;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The prefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prefix;
    /**
     * The firstname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstname;
    /**
     * The middlename
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $middlename;
    /**
     * The lastname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastname;
    /**
     * The suffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $suffix;
    /**
     * The company
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $company;
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $region;
    /**
     * The region_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $region_id;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * The country_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country_id;
    /**
     * The telephone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telephone;
    /**
     * The fax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The same_as_billing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $same_as_billing;
    /**
     * The free_shipping
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $free_shipping;
    /**
     * The shipping_method
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipping_method;
    /**
     * The shipping_description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipping_description;
    /**
     * The weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weight;
    /**
     * Constructor method for shoppingCartAddressEntity
     * @uses ShoppingCartAddressEntity::setAddress_id()
     * @uses ShoppingCartAddressEntity::setCreated_at()
     * @uses ShoppingCartAddressEntity::setUpdated_at()
     * @uses ShoppingCartAddressEntity::setCustomer_id()
     * @uses ShoppingCartAddressEntity::setSave_in_address_book()
     * @uses ShoppingCartAddressEntity::setCustomer_address_id()
     * @uses ShoppingCartAddressEntity::setAddress_type()
     * @uses ShoppingCartAddressEntity::setEmail()
     * @uses ShoppingCartAddressEntity::setPrefix()
     * @uses ShoppingCartAddressEntity::setFirstname()
     * @uses ShoppingCartAddressEntity::setMiddlename()
     * @uses ShoppingCartAddressEntity::setLastname()
     * @uses ShoppingCartAddressEntity::setSuffix()
     * @uses ShoppingCartAddressEntity::setCompany()
     * @uses ShoppingCartAddressEntity::setStreet()
     * @uses ShoppingCartAddressEntity::setCity()
     * @uses ShoppingCartAddressEntity::setRegion()
     * @uses ShoppingCartAddressEntity::setRegion_id()
     * @uses ShoppingCartAddressEntity::setPostcode()
     * @uses ShoppingCartAddressEntity::setCountry_id()
     * @uses ShoppingCartAddressEntity::setTelephone()
     * @uses ShoppingCartAddressEntity::setFax()
     * @uses ShoppingCartAddressEntity::setSame_as_billing()
     * @uses ShoppingCartAddressEntity::setFree_shipping()
     * @uses ShoppingCartAddressEntity::setShipping_method()
     * @uses ShoppingCartAddressEntity::setShipping_description()
     * @uses ShoppingCartAddressEntity::setWeight()
     * @param string $address_id
     * @param string $created_at
     * @param string $updated_at
     * @param string $customer_id
     * @param int $save_in_address_book
     * @param string $customer_address_id
     * @param string $address_type
     * @param string $email
     * @param string $prefix
     * @param string $firstname
     * @param string $middlename
     * @param string $lastname
     * @param string $suffix
     * @param string $company
     * @param string $street
     * @param string $city
     * @param string $region
     * @param string $region_id
     * @param string $postcode
     * @param string $country_id
     * @param string $telephone
     * @param string $fax
     * @param int $same_as_billing
     * @param int $free_shipping
     * @param string $shipping_method
     * @param string $shipping_description
     * @param float $weight
     */
    public function __construct($address_id = null, $created_at = null, $updated_at = null, $customer_id = null, $save_in_address_book = null, $customer_address_id = null, $address_type = null, $email = null, $prefix = null, $firstname = null, $middlename = null, $lastname = null, $suffix = null, $company = null, $street = null, $city = null, $region = null, $region_id = null, $postcode = null, $country_id = null, $telephone = null, $fax = null, $same_as_billing = null, $free_shipping = null, $shipping_method = null, $shipping_description = null, $weight = null)
    {
        $this
            ->setAddress_id($address_id)
            ->setCreated_at($created_at)
            ->setUpdated_at($updated_at)
            ->setCustomer_id($customer_id)
            ->setSave_in_address_book($save_in_address_book)
            ->setCustomer_address_id($customer_address_id)
            ->setAddress_type($address_type)
            ->setEmail($email)
            ->setPrefix($prefix)
            ->setFirstname($firstname)
            ->setMiddlename($middlename)
            ->setLastname($lastname)
            ->setSuffix($suffix)
            ->setCompany($company)
            ->setStreet($street)
            ->setCity($city)
            ->setRegion($region)
            ->setRegion_id($region_id)
            ->setPostcode($postcode)
            ->setCountry_id($country_id)
            ->setTelephone($telephone)
            ->setFax($fax)
            ->setSame_as_billing($same_as_billing)
            ->setFree_shipping($free_shipping)
            ->setShipping_method($shipping_method)
            ->setShipping_description($shipping_description)
            ->setWeight($weight);
    }
    /**
     * Get address_id value
     * @return string|null
     */
    public function getAddress_id()
    {
        return $this->address_id;
    }
    /**
     * Set address_id value
     * @param string $address_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setAddress_id($address_id = null)
    {
        // validation for constraint: string
        if (!is_null($address_id) && !is_string($address_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address_id)), __LINE__);
        }
        $this->address_id = $address_id;
        return $this;
    }
    /**
     * Get created_at value
     * @return string|null
     */
    public function getCreated_at()
    {
        return $this->created_at;
    }
    /**
     * Set created_at value
     * @param string $created_at
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setCreated_at($created_at = null)
    {
        // validation for constraint: string
        if (!is_null($created_at) && !is_string($created_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created_at)), __LINE__);
        }
        $this->created_at = $created_at;
        return $this;
    }
    /**
     * Get updated_at value
     * @return string|null
     */
    public function getUpdated_at()
    {
        return $this->updated_at;
    }
    /**
     * Set updated_at value
     * @param string $updated_at
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setUpdated_at($updated_at = null)
    {
        // validation for constraint: string
        if (!is_null($updated_at) && !is_string($updated_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updated_at)), __LINE__);
        }
        $this->updated_at = $updated_at;
        return $this;
    }
    /**
     * Get customer_id value
     * @return string|null
     */
    public function getCustomer_id()
    {
        return $this->customer_id;
    }
    /**
     * Set customer_id value
     * @param string $customer_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setCustomer_id($customer_id = null)
    {
        // validation for constraint: string
        if (!is_null($customer_id) && !is_string($customer_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_id)), __LINE__);
        }
        $this->customer_id = $customer_id;
        return $this;
    }
    /**
     * Get save_in_address_book value
     * @return int|null
     */
    public function getSave_in_address_book()
    {
        return $this->save_in_address_book;
    }
    /**
     * Set save_in_address_book value
     * @param int $save_in_address_book
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setSave_in_address_book($save_in_address_book = null)
    {
        // validation for constraint: int
        if (!is_null($save_in_address_book) && !is_numeric($save_in_address_book)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($save_in_address_book)), __LINE__);
        }
        $this->save_in_address_book = $save_in_address_book;
        return $this;
    }
    /**
     * Get customer_address_id value
     * @return string|null
     */
    public function getCustomer_address_id()
    {
        return $this->customer_address_id;
    }
    /**
     * Set customer_address_id value
     * @param string $customer_address_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setCustomer_address_id($customer_address_id = null)
    {
        // validation for constraint: string
        if (!is_null($customer_address_id) && !is_string($customer_address_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_address_id)), __LINE__);
        }
        $this->customer_address_id = $customer_address_id;
        return $this;
    }
    /**
     * Get address_type value
     * @return string|null
     */
    public function getAddress_type()
    {
        return $this->address_type;
    }
    /**
     * Set address_type value
     * @param string $address_type
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setAddress_type($address_type = null)
    {
        // validation for constraint: string
        if (!is_null($address_type) && !is_string($address_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address_type)), __LINE__);
        }
        $this->address_type = $address_type;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefix)), __LINE__);
        }
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get middlename value
     * @return string|null
     */
    public function getMiddlename()
    {
        return $this->middlename;
    }
    /**
     * Set middlename value
     * @param string $middlename
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setMiddlename($middlename = null)
    {
        // validation for constraint: string
        if (!is_null($middlename) && !is_string($middlename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middlename)), __LINE__);
        }
        $this->middlename = $middlename;
        return $this;
    }
    /**
     * Get lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->lastname;
    }
    /**
     * Set lastname value
     * @param string $lastname
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastname)), __LINE__);
        }
        $this->lastname = $lastname;
        return $this;
    }
    /**
     * Get suffix value
     * @return string|null
     */
    public function getSuffix()
    {
        return $this->suffix;
    }
    /**
     * Set suffix value
     * @param string $suffix
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suffix)), __LINE__);
        }
        $this->suffix = $suffix;
        return $this;
    }
    /**
     * Get company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param string $company
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get region_id value
     * @return string|null
     */
    public function getRegion_id()
    {
        return $this->region_id;
    }
    /**
     * Set region_id value
     * @param string $region_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setRegion_id($region_id = null)
    {
        // validation for constraint: string
        if (!is_null($region_id) && !is_string($region_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region_id)), __LINE__);
        }
        $this->region_id = $region_id;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get country_id value
     * @return string|null
     */
    public function getCountry_id()
    {
        return $this->country_id;
    }
    /**
     * Set country_id value
     * @param string $country_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setCountry_id($country_id = null)
    {
        // validation for constraint: string
        if (!is_null($country_id) && !is_string($country_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country_id)), __LINE__);
        }
        $this->country_id = $country_id;
        return $this;
    }
    /**
     * Get telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->telephone;
    }
    /**
     * Set telephone value
     * @param string $telephone
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephone)), __LINE__);
        }
        $this->telephone = $telephone;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get same_as_billing value
     * @return int|null
     */
    public function getSame_as_billing()
    {
        return $this->same_as_billing;
    }
    /**
     * Set same_as_billing value
     * @param int $same_as_billing
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setSame_as_billing($same_as_billing = null)
    {
        // validation for constraint: int
        if (!is_null($same_as_billing) && !is_numeric($same_as_billing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($same_as_billing)), __LINE__);
        }
        $this->same_as_billing = $same_as_billing;
        return $this;
    }
    /**
     * Get free_shipping value
     * @return int|null
     */
    public function getFree_shipping()
    {
        return $this->free_shipping;
    }
    /**
     * Set free_shipping value
     * @param int $free_shipping
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setFree_shipping($free_shipping = null)
    {
        // validation for constraint: int
        if (!is_null($free_shipping) && !is_numeric($free_shipping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($free_shipping)), __LINE__);
        }
        $this->free_shipping = $free_shipping;
        return $this;
    }
    /**
     * Get shipping_method value
     * @return string|null
     */
    public function getShipping_method()
    {
        return $this->shipping_method;
    }
    /**
     * Set shipping_method value
     * @param string $shipping_method
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setShipping_method($shipping_method = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_method) && !is_string($shipping_method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipping_method)), __LINE__);
        }
        $this->shipping_method = $shipping_method;
        return $this;
    }
    /**
     * Get shipping_description value
     * @return string|null
     */
    public function getShipping_description()
    {
        return $this->shipping_description;
    }
    /**
     * Set shipping_description value
     * @param string $shipping_description
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setShipping_description($shipping_description = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_description) && !is_string($shipping_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipping_description)), __LINE__);
        }
        $this->shipping_description = $shipping_description;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public function setWeight($weight = null)
    {
        $this->weight = $weight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
