<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for salesOrderShipmentSendInfoRequestParam StructType
 * @subpackage Structs
 */
class SalesOrderShipmentSendInfoRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The shipmentIncrementId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $shipmentIncrementId;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * Constructor method for salesOrderShipmentSendInfoRequestParam
     * @uses SalesOrderShipmentSendInfoRequestParam::setSessionId()
     * @uses SalesOrderShipmentSendInfoRequestParam::setShipmentIncrementId()
     * @uses SalesOrderShipmentSendInfoRequestParam::setComment()
     * @param string $sessionId
     * @param string $shipmentIncrementId
     * @param string $comment
     */
    public function __construct($sessionId = null, $shipmentIncrementId = null, $comment = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setShipmentIncrementId($shipmentIncrementId)
            ->setComment($comment);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentSendInfoRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get shipmentIncrementId value
     * @return string
     */
    public function getShipmentIncrementId()
    {
        return $this->shipmentIncrementId;
    }
    /**
     * Set shipmentIncrementId value
     * @param string $shipmentIncrementId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentSendInfoRequestParam
     */
    public function setShipmentIncrementId($shipmentIncrementId = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentIncrementId) && !is_string($shipmentIncrementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentIncrementId)), __LINE__);
        }
        $this->shipmentIncrementId = $shipmentIncrementId;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentSendInfoRequestParam
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentSendInfoRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
