<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for salesOrderShipmentEntity StructType
 * @subpackage Structs
 */
class SalesOrderShipmentEntity extends AbstractStructBase
{
    /**
     * The increment_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $increment_id;
    /**
     * The parent_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $parent_id;
    /**
     * The store_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $store_id;
    /**
     * The created_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $created_at;
    /**
     * The updated_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $updated_at;
    /**
     * The is_active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $is_active;
    /**
     * The shipping_address_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipping_address_id;
    /**
     * The shipping_firstname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipping_firstname;
    /**
     * The shipping_lastname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipping_lastname;
    /**
     * The order_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $order_id;
    /**
     * The order_increment_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $order_increment_id;
    /**
     * The order_created_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $order_created_at;
    /**
     * The total_qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $total_qty;
    /**
     * The shipment_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipment_id;
    /**
     * The items
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentItemEntityArray
     */
    public $items;
    /**
     * The tracks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentTrackEntityArray
     */
    public $tracks;
    /**
     * The comments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentCommentEntityArray
     */
    public $comments;
    /**
     * Constructor method for salesOrderShipmentEntity
     * @uses SalesOrderShipmentEntity::setIncrement_id()
     * @uses SalesOrderShipmentEntity::setParent_id()
     * @uses SalesOrderShipmentEntity::setStore_id()
     * @uses SalesOrderShipmentEntity::setCreated_at()
     * @uses SalesOrderShipmentEntity::setUpdated_at()
     * @uses SalesOrderShipmentEntity::setIs_active()
     * @uses SalesOrderShipmentEntity::setShipping_address_id()
     * @uses SalesOrderShipmentEntity::setShipping_firstname()
     * @uses SalesOrderShipmentEntity::setShipping_lastname()
     * @uses SalesOrderShipmentEntity::setOrder_id()
     * @uses SalesOrderShipmentEntity::setOrder_increment_id()
     * @uses SalesOrderShipmentEntity::setOrder_created_at()
     * @uses SalesOrderShipmentEntity::setTotal_qty()
     * @uses SalesOrderShipmentEntity::setShipment_id()
     * @uses SalesOrderShipmentEntity::setItems()
     * @uses SalesOrderShipmentEntity::setTracks()
     * @uses SalesOrderShipmentEntity::setComments()
     * @param string $increment_id
     * @param string $parent_id
     * @param string $store_id
     * @param string $created_at
     * @param string $updated_at
     * @param string $is_active
     * @param string $shipping_address_id
     * @param string $shipping_firstname
     * @param string $shipping_lastname
     * @param string $order_id
     * @param string $order_increment_id
     * @param string $order_created_at
     * @param string $total_qty
     * @param string $shipment_id
     * @param \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentItemEntityArray $items
     * @param \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentTrackEntityArray $tracks
     * @param \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentCommentEntityArray $comments
     */
    public function __construct($increment_id = null, $parent_id = null, $store_id = null, $created_at = null, $updated_at = null, $is_active = null, $shipping_address_id = null, $shipping_firstname = null, $shipping_lastname = null, $order_id = null, $order_increment_id = null, $order_created_at = null, $total_qty = null, $shipment_id = null, \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentItemEntityArray $items = null, \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentTrackEntityArray $tracks = null, \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentCommentEntityArray $comments = null)
    {
        $this
            ->setIncrement_id($increment_id)
            ->setParent_id($parent_id)
            ->setStore_id($store_id)
            ->setCreated_at($created_at)
            ->setUpdated_at($updated_at)
            ->setIs_active($is_active)
            ->setShipping_address_id($shipping_address_id)
            ->setShipping_firstname($shipping_firstname)
            ->setShipping_lastname($shipping_lastname)
            ->setOrder_id($order_id)
            ->setOrder_increment_id($order_increment_id)
            ->setOrder_created_at($order_created_at)
            ->setTotal_qty($total_qty)
            ->setShipment_id($shipment_id)
            ->setItems($items)
            ->setTracks($tracks)
            ->setComments($comments);
    }
    /**
     * Get increment_id value
     * @return string|null
     */
    public function getIncrement_id()
    {
        return $this->increment_id;
    }
    /**
     * Set increment_id value
     * @param string $increment_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setIncrement_id($increment_id = null)
    {
        // validation for constraint: string
        if (!is_null($increment_id) && !is_string($increment_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($increment_id)), __LINE__);
        }
        $this->increment_id = $increment_id;
        return $this;
    }
    /**
     * Get parent_id value
     * @return string|null
     */
    public function getParent_id()
    {
        return $this->parent_id;
    }
    /**
     * Set parent_id value
     * @param string $parent_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setParent_id($parent_id = null)
    {
        // validation for constraint: string
        if (!is_null($parent_id) && !is_string($parent_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parent_id)), __LINE__);
        }
        $this->parent_id = $parent_id;
        return $this;
    }
    /**
     * Get store_id value
     * @return string|null
     */
    public function getStore_id()
    {
        return $this->store_id;
    }
    /**
     * Set store_id value
     * @param string $store_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setStore_id($store_id = null)
    {
        // validation for constraint: string
        if (!is_null($store_id) && !is_string($store_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store_id)), __LINE__);
        }
        $this->store_id = $store_id;
        return $this;
    }
    /**
     * Get created_at value
     * @return string|null
     */
    public function getCreated_at()
    {
        return $this->created_at;
    }
    /**
     * Set created_at value
     * @param string $created_at
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setCreated_at($created_at = null)
    {
        // validation for constraint: string
        if (!is_null($created_at) && !is_string($created_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created_at)), __LINE__);
        }
        $this->created_at = $created_at;
        return $this;
    }
    /**
     * Get updated_at value
     * @return string|null
     */
    public function getUpdated_at()
    {
        return $this->updated_at;
    }
    /**
     * Set updated_at value
     * @param string $updated_at
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setUpdated_at($updated_at = null)
    {
        // validation for constraint: string
        if (!is_null($updated_at) && !is_string($updated_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updated_at)), __LINE__);
        }
        $this->updated_at = $updated_at;
        return $this;
    }
    /**
     * Get is_active value
     * @return string|null
     */
    public function getIs_active()
    {
        return $this->is_active;
    }
    /**
     * Set is_active value
     * @param string $is_active
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setIs_active($is_active = null)
    {
        // validation for constraint: string
        if (!is_null($is_active) && !is_string($is_active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($is_active)), __LINE__);
        }
        $this->is_active = $is_active;
        return $this;
    }
    /**
     * Get shipping_address_id value
     * @return string|null
     */
    public function getShipping_address_id()
    {
        return $this->shipping_address_id;
    }
    /**
     * Set shipping_address_id value
     * @param string $shipping_address_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setShipping_address_id($shipping_address_id = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_address_id) && !is_string($shipping_address_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipping_address_id)), __LINE__);
        }
        $this->shipping_address_id = $shipping_address_id;
        return $this;
    }
    /**
     * Get shipping_firstname value
     * @return string|null
     */
    public function getShipping_firstname()
    {
        return $this->shipping_firstname;
    }
    /**
     * Set shipping_firstname value
     * @param string $shipping_firstname
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setShipping_firstname($shipping_firstname = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_firstname) && !is_string($shipping_firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipping_firstname)), __LINE__);
        }
        $this->shipping_firstname = $shipping_firstname;
        return $this;
    }
    /**
     * Get shipping_lastname value
     * @return string|null
     */
    public function getShipping_lastname()
    {
        return $this->shipping_lastname;
    }
    /**
     * Set shipping_lastname value
     * @param string $shipping_lastname
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setShipping_lastname($shipping_lastname = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_lastname) && !is_string($shipping_lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipping_lastname)), __LINE__);
        }
        $this->shipping_lastname = $shipping_lastname;
        return $this;
    }
    /**
     * Get order_id value
     * @return string|null
     */
    public function getOrder_id()
    {
        return $this->order_id;
    }
    /**
     * Set order_id value
     * @param string $order_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setOrder_id($order_id = null)
    {
        // validation for constraint: string
        if (!is_null($order_id) && !is_string($order_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_id)), __LINE__);
        }
        $this->order_id = $order_id;
        return $this;
    }
    /**
     * Get order_increment_id value
     * @return string|null
     */
    public function getOrder_increment_id()
    {
        return $this->order_increment_id;
    }
    /**
     * Set order_increment_id value
     * @param string $order_increment_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setOrder_increment_id($order_increment_id = null)
    {
        // validation for constraint: string
        if (!is_null($order_increment_id) && !is_string($order_increment_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_increment_id)), __LINE__);
        }
        $this->order_increment_id = $order_increment_id;
        return $this;
    }
    /**
     * Get order_created_at value
     * @return string|null
     */
    public function getOrder_created_at()
    {
        return $this->order_created_at;
    }
    /**
     * Set order_created_at value
     * @param string $order_created_at
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setOrder_created_at($order_created_at = null)
    {
        // validation for constraint: string
        if (!is_null($order_created_at) && !is_string($order_created_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_created_at)), __LINE__);
        }
        $this->order_created_at = $order_created_at;
        return $this;
    }
    /**
     * Get total_qty value
     * @return string|null
     */
    public function getTotal_qty()
    {
        return $this->total_qty;
    }
    /**
     * Set total_qty value
     * @param string $total_qty
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setTotal_qty($total_qty = null)
    {
        // validation for constraint: string
        if (!is_null($total_qty) && !is_string($total_qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($total_qty)), __LINE__);
        }
        $this->total_qty = $total_qty;
        return $this;
    }
    /**
     * Get shipment_id value
     * @return string|null
     */
    public function getShipment_id()
    {
        return $this->shipment_id;
    }
    /**
     * Set shipment_id value
     * @param string $shipment_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setShipment_id($shipment_id = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_id) && !is_string($shipment_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipment_id)), __LINE__);
        }
        $this->shipment_id = $shipment_id;
        return $this;
    }
    /**
     * Get items value
     * @return \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentItemEntityArray|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * Set items value
     * @param \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentItemEntityArray $items
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setItems(\App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentItemEntityArray $items = null)
    {
        $this->items = $items;
        return $this;
    }
    /**
     * Get tracks value
     * @return \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentTrackEntityArray|null
     */
    public function getTracks()
    {
        return $this->tracks;
    }
    /**
     * Set tracks value
     * @param \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentTrackEntityArray $tracks
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setTracks(\App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentTrackEntityArray $tracks = null)
    {
        $this->tracks = $tracks;
        return $this;
    }
    /**
     * Get comments value
     * @return \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentCommentEntityArray|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param \App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentCommentEntityArray $comments
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public function setComments(\App\Api\Client\Magento\Type\ArrayType\SalesOrderShipmentCommentEntityArray $comments = null)
    {
        $this->comments = $comments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
