<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for salesOrderShipmentAddCommentRequestParam StructType
 * @subpackage Structs
 */
class SalesOrderShipmentAddCommentRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The shipmentIncrementId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $shipmentIncrementId;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $email;
    /**
     * The includeInEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $includeInEmail;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * Constructor method for salesOrderShipmentAddCommentRequestParam
     * @uses SalesOrderShipmentAddCommentRequestParam::setSessionId()
     * @uses SalesOrderShipmentAddCommentRequestParam::setShipmentIncrementId()
     * @uses SalesOrderShipmentAddCommentRequestParam::setEmail()
     * @uses SalesOrderShipmentAddCommentRequestParam::setIncludeInEmail()
     * @uses SalesOrderShipmentAddCommentRequestParam::setComment()
     * @param string $sessionId
     * @param string $shipmentIncrementId
     * @param string $email
     * @param string $includeInEmail
     * @param string $comment
     */
    public function __construct($sessionId = null, $shipmentIncrementId = null, $email = null, $includeInEmail = null, $comment = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setShipmentIncrementId($shipmentIncrementId)
            ->setEmail($email)
            ->setIncludeInEmail($includeInEmail)
            ->setComment($comment);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddCommentRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get shipmentIncrementId value
     * @return string
     */
    public function getShipmentIncrementId()
    {
        return $this->shipmentIncrementId;
    }
    /**
     * Set shipmentIncrementId value
     * @param string $shipmentIncrementId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddCommentRequestParam
     */
    public function setShipmentIncrementId($shipmentIncrementId = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentIncrementId) && !is_string($shipmentIncrementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentIncrementId)), __LINE__);
        }
        $this->shipmentIncrementId = $shipmentIncrementId;
        return $this;
    }
    /**
     * Get email value
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddCommentRequestParam
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get includeInEmail value
     * @return string
     */
    public function getIncludeInEmail()
    {
        return $this->includeInEmail;
    }
    /**
     * Set includeInEmail value
     * @param string $includeInEmail
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddCommentRequestParam
     */
    public function setIncludeInEmail($includeInEmail = null)
    {
        // validation for constraint: string
        if (!is_null($includeInEmail) && !is_string($includeInEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($includeInEmail)), __LINE__);
        }
        $this->includeInEmail = $includeInEmail;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddCommentRequestParam
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddCommentRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
