<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for salesOrderInvoiceInfoRequestParam StructType
 * @subpackage Structs
 */
class SalesOrderInvoiceInfoRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The invoiceIncrementId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $invoiceIncrementId;
    /**
     * Constructor method for salesOrderInvoiceInfoRequestParam
     * @uses SalesOrderInvoiceInfoRequestParam::setSessionId()
     * @uses SalesOrderInvoiceInfoRequestParam::setInvoiceIncrementId()
     * @param string $sessionId
     * @param string $invoiceIncrementId
     */
    public function __construct($sessionId = null, $invoiceIncrementId = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setInvoiceIncrementId($invoiceIncrementId);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceInfoRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get invoiceIncrementId value
     * @return string
     */
    public function getInvoiceIncrementId()
    {
        return $this->invoiceIncrementId;
    }
    /**
     * Set invoiceIncrementId value
     * @param string $invoiceIncrementId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceInfoRequestParam
     */
    public function setInvoiceIncrementId($invoiceIncrementId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceIncrementId) && !is_string($invoiceIncrementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceIncrementId)), __LINE__);
        }
        $this->invoiceIncrementId = $invoiceIncrementId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceInfoRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
