<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for salesOrderCreditmemoAddCommentRequestParam StructType
 * @subpackage Structs
 */
class SalesOrderCreditmemoAddCommentRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The creditmemoIncrementId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $creditmemoIncrementId;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The notifyCustomer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $notifyCustomer;
    /**
     * The includeComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $includeComment;
    /**
     * Constructor method for salesOrderCreditmemoAddCommentRequestParam
     * @uses SalesOrderCreditmemoAddCommentRequestParam::setSessionId()
     * @uses SalesOrderCreditmemoAddCommentRequestParam::setCreditmemoIncrementId()
     * @uses SalesOrderCreditmemoAddCommentRequestParam::setComment()
     * @uses SalesOrderCreditmemoAddCommentRequestParam::setNotifyCustomer()
     * @uses SalesOrderCreditmemoAddCommentRequestParam::setIncludeComment()
     * @param string $sessionId
     * @param string $creditmemoIncrementId
     * @param string $comment
     * @param int $notifyCustomer
     * @param int $includeComment
     */
    public function __construct($sessionId = null, $creditmemoIncrementId = null, $comment = null, $notifyCustomer = null, $includeComment = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setCreditmemoIncrementId($creditmemoIncrementId)
            ->setComment($comment)
            ->setNotifyCustomer($notifyCustomer)
            ->setIncludeComment($includeComment);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoAddCommentRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get creditmemoIncrementId value
     * @return string
     */
    public function getCreditmemoIncrementId()
    {
        return $this->creditmemoIncrementId;
    }
    /**
     * Set creditmemoIncrementId value
     * @param string $creditmemoIncrementId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoAddCommentRequestParam
     */
    public function setCreditmemoIncrementId($creditmemoIncrementId = null)
    {
        // validation for constraint: string
        if (!is_null($creditmemoIncrementId) && !is_string($creditmemoIncrementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditmemoIncrementId)), __LINE__);
        }
        $this->creditmemoIncrementId = $creditmemoIncrementId;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoAddCommentRequestParam
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get notifyCustomer value
     * @return int|null
     */
    public function getNotifyCustomer()
    {
        return $this->notifyCustomer;
    }
    /**
     * Set notifyCustomer value
     * @param int $notifyCustomer
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoAddCommentRequestParam
     */
    public function setNotifyCustomer($notifyCustomer = null)
    {
        // validation for constraint: int
        if (!is_null($notifyCustomer) && !is_numeric($notifyCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notifyCustomer)), __LINE__);
        }
        $this->notifyCustomer = $notifyCustomer;
        return $this;
    }
    /**
     * Get includeComment value
     * @return int|null
     */
    public function getIncludeComment()
    {
        return $this->includeComment;
    }
    /**
     * Set includeComment value
     * @param int $includeComment
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoAddCommentRequestParam
     */
    public function setIncludeComment($includeComment = null)
    {
        // validation for constraint: int
        if (!is_null($includeComment) && !is_numeric($includeComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($includeComment)), __LINE__);
        }
        $this->includeComment = $includeComment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoAddCommentRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
