<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for salesOrderAddCommentRequestParam StructType
 * @subpackage Structs
 */
class SalesOrderAddCommentRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The orderIncrementId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $orderIncrementId;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The notify
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $notify;
    /**
     * Constructor method for salesOrderAddCommentRequestParam
     * @uses SalesOrderAddCommentRequestParam::setSessionId()
     * @uses SalesOrderAddCommentRequestParam::setOrderIncrementId()
     * @uses SalesOrderAddCommentRequestParam::setStatus()
     * @uses SalesOrderAddCommentRequestParam::setComment()
     * @uses SalesOrderAddCommentRequestParam::setNotify()
     * @param string $sessionId
     * @param string $orderIncrementId
     * @param string $status
     * @param string $comment
     * @param int $notify
     */
    public function __construct($sessionId = null, $orderIncrementId = null, $status = null, $comment = null, $notify = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setOrderIncrementId($orderIncrementId)
            ->setStatus($status)
            ->setComment($comment)
            ->setNotify($notify);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderAddCommentRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get orderIncrementId value
     * @return string
     */
    public function getOrderIncrementId()
    {
        return $this->orderIncrementId;
    }
    /**
     * Set orderIncrementId value
     * @param string $orderIncrementId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderAddCommentRequestParam
     */
    public function setOrderIncrementId($orderIncrementId = null)
    {
        // validation for constraint: string
        if (!is_null($orderIncrementId) && !is_string($orderIncrementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderIncrementId)), __LINE__);
        }
        $this->orderIncrementId = $orderIncrementId;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderAddCommentRequestParam
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderAddCommentRequestParam
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get notify value
     * @return int|null
     */
    public function getNotify()
    {
        return $this->notify;
    }
    /**
     * Set notify value
     * @param int $notify
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderAddCommentRequestParam
     */
    public function setNotify($notify = null)
    {
        // validation for constraint: int
        if (!is_null($notify) && !is_numeric($notify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notify)), __LINE__);
        }
        $this->notify = $notify;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderAddCommentRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
