<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orderItemIdQty StructType
 * @subpackage Structs
 */
class OrderItemIdQty extends AbstractStructBase
{
    /**
     * The order_item_id
     * @var int
     */
    public $order_item_id;
    /**
     * The qty
     * @var float
     */
    public $qty;
    /**
     * Constructor method for orderItemIdQty
     * @uses OrderItemIdQty::setOrder_item_id()
     * @uses OrderItemIdQty::setQty()
     * @param int $order_item_id
     * @param float $qty
     */
    public function __construct($order_item_id = null, $qty = null)
    {
        $this
            ->setOrder_item_id($order_item_id)
            ->setQty($qty);
    }
    /**
     * Get order_item_id value
     * @return int|null
     */
    public function getOrder_item_id()
    {
        return $this->order_item_id;
    }
    /**
     * Set order_item_id value
     * @param int $order_item_id
     * @return \App\Api\Client\Magento\Type\StructType\OrderItemIdQty
     */
    public function setOrder_item_id($order_item_id = null)
    {
        // validation for constraint: int
        if (!is_null($order_item_id) && !is_numeric($order_item_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order_item_id)), __LINE__);
        }
        $this->order_item_id = $order_item_id;
        return $this;
    }
    /**
     * Get qty value
     * @return float|null
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param float $qty
     * @return \App\Api\Client\Magento\Type\StructType\OrderItemIdQty
     */
    public function setQty($qty = null)
    {
        $this->qty = $qty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\OrderItemIdQty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
