<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for multiCallParam StructType
 * @subpackage Structs
 */
class MultiCallParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The calls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var mixed
     */
    public $calls;
    /**
     * The options
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var mixed
     */
    public $options;
    /**
     * Constructor method for multiCallParam
     * @uses MultiCallParam::setSessionId()
     * @uses MultiCallParam::setCalls()
     * @uses MultiCallParam::setOptions()
     * @param string $sessionId
     * @param mixed $calls
     * @param mixed $options
     */
    public function __construct($sessionId = null, $calls = null, $options = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setCalls($calls)
            ->setOptions($options);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\MultiCallParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get calls value
     * @return mixed
     */
    public function getCalls()
    {
        return $this->calls;
    }
    /**
     * Set calls value
     * @param mixed $calls
     * @return \App\Api\Client\Magento\Type\StructType\MultiCallParam
     */
    public function setCalls($calls = null)
    {
        $this->calls = $calls;
        return $this;
    }
    /**
     * Get options value
     * @return mixed
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param mixed $options
     * @return \App\Api\Client\Magento\Type\StructType\MultiCallParam
     */
    public function setOptions($options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\MultiCallParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
