<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for magentoInfoEntity StructType
 * @subpackage Structs
 */
class MagentoInfoEntity extends AbstractStructBase
{
    /**
     * The magento_version
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $magento_version;
    /**
     * The magento_edition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $magento_edition;
    /**
     * Constructor method for magentoInfoEntity
     * @uses MagentoInfoEntity::setMagento_version()
     * @uses MagentoInfoEntity::setMagento_edition()
     * @param string $magento_version
     * @param string $magento_edition
     */
    public function __construct($magento_version = null, $magento_edition = null)
    {
        $this
            ->setMagento_version($magento_version)
            ->setMagento_edition($magento_edition);
    }
    /**
     * Get magento_version value
     * @return string
     */
    public function getMagento_version()
    {
        return $this->magento_version;
    }
    /**
     * Set magento_version value
     * @param string $magento_version
     * @return \App\Api\Client\Magento\Type\StructType\MagentoInfoEntity
     */
    public function setMagento_version($magento_version = null)
    {
        // validation for constraint: string
        if (!is_null($magento_version) && !is_string($magento_version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($magento_version)), __LINE__);
        }
        $this->magento_version = $magento_version;
        return $this;
    }
    /**
     * Get magento_edition value
     * @return string
     */
    public function getMagento_edition()
    {
        return $this->magento_edition;
    }
    /**
     * Set magento_edition value
     * @param string $magento_edition
     * @return \App\Api\Client\Magento\Type\StructType\MagentoInfoEntity
     */
    public function setMagento_edition($magento_edition = null)
    {
        // validation for constraint: string
        if (!is_null($magento_edition) && !is_string($magento_edition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($magento_edition)), __LINE__);
        }
        $this->magento_edition = $magento_edition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\MagentoInfoEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
