<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for giftMessageForQuoteProductRequestParam StructType
 * @subpackage Structs
 */
class GiftMessageForQuoteProductRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The quoteId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $quoteId;
    /**
     * The productsAndMessages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\ArrayType\GiftMessageAssociativeProductsEntityArray
     */
    public $productsAndMessages;
    /**
     * The store
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $store;
    /**
     * Constructor method for giftMessageForQuoteProductRequestParam
     * @uses GiftMessageForQuoteProductRequestParam::setSessionId()
     * @uses GiftMessageForQuoteProductRequestParam::setQuoteId()
     * @uses GiftMessageForQuoteProductRequestParam::setProductsAndMessages()
     * @uses GiftMessageForQuoteProductRequestParam::setStore()
     * @param string $sessionId
     * @param string $quoteId
     * @param \App\Api\Client\Magento\Type\ArrayType\GiftMessageAssociativeProductsEntityArray $productsAndMessages
     * @param string $store
     */
    public function __construct($sessionId = null, $quoteId = null, \App\Api\Client\Magento\Type\ArrayType\GiftMessageAssociativeProductsEntityArray $productsAndMessages = null, $store = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setQuoteId($quoteId)
            ->setProductsAndMessages($productsAndMessages)
            ->setStore($store);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteProductRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get quoteId value
     * @return string
     */
    public function getQuoteId()
    {
        return $this->quoteId;
    }
    /**
     * Set quoteId value
     * @param string $quoteId
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteProductRequestParam
     */
    public function setQuoteId($quoteId = null)
    {
        // validation for constraint: string
        if (!is_null($quoteId) && !is_string($quoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quoteId)), __LINE__);
        }
        $this->quoteId = $quoteId;
        return $this;
    }
    /**
     * Get productsAndMessages value
     * @return \App\Api\Client\Magento\Type\ArrayType\GiftMessageAssociativeProductsEntityArray
     */
    public function getProductsAndMessages()
    {
        return $this->productsAndMessages;
    }
    /**
     * Set productsAndMessages value
     * @param \App\Api\Client\Magento\Type\ArrayType\GiftMessageAssociativeProductsEntityArray $productsAndMessages
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteProductRequestParam
     */
    public function setProductsAndMessages(\App\Api\Client\Magento\Type\ArrayType\GiftMessageAssociativeProductsEntityArray $productsAndMessages = null)
    {
        $this->productsAndMessages = $productsAndMessages;
        return $this;
    }
    /**
     * Get store value
     * @return string|null
     */
    public function getStore()
    {
        return $this->store;
    }
    /**
     * Set store value
     * @param string $store
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteProductRequestParam
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        $this->store = $store;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteProductRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
