<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for directoryCountryEntity StructType
 * @subpackage Structs
 */
class DirectoryCountryEntity extends AbstractStructBase
{
    /**
     * The country_id
     * @var string
     */
    public $country_id;
    /**
     * The iso2_code
     * @var string
     */
    public $iso2_code;
    /**
     * The iso3_code
     * @var string
     */
    public $iso3_code;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * Constructor method for directoryCountryEntity
     * @uses DirectoryCountryEntity::setCountry_id()
     * @uses DirectoryCountryEntity::setIso2_code()
     * @uses DirectoryCountryEntity::setIso3_code()
     * @uses DirectoryCountryEntity::setName()
     * @param string $country_id
     * @param string $iso2_code
     * @param string $iso3_code
     * @param string $name
     */
    public function __construct($country_id = null, $iso2_code = null, $iso3_code = null, $name = null)
    {
        $this
            ->setCountry_id($country_id)
            ->setIso2_code($iso2_code)
            ->setIso3_code($iso3_code)
            ->setName($name);
    }
    /**
     * Get country_id value
     * @return string|null
     */
    public function getCountry_id()
    {
        return $this->country_id;
    }
    /**
     * Set country_id value
     * @param string $country_id
     * @return \App\Api\Client\Magento\Type\StructType\DirectoryCountryEntity
     */
    public function setCountry_id($country_id = null)
    {
        // validation for constraint: string
        if (!is_null($country_id) && !is_string($country_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country_id)), __LINE__);
        }
        $this->country_id = $country_id;
        return $this;
    }
    /**
     * Get iso2_code value
     * @return string|null
     */
    public function getIso2_code()
    {
        return $this->iso2_code;
    }
    /**
     * Set iso2_code value
     * @param string $iso2_code
     * @return \App\Api\Client\Magento\Type\StructType\DirectoryCountryEntity
     */
    public function setIso2_code($iso2_code = null)
    {
        // validation for constraint: string
        if (!is_null($iso2_code) && !is_string($iso2_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso2_code)), __LINE__);
        }
        $this->iso2_code = $iso2_code;
        return $this;
    }
    /**
     * Get iso3_code value
     * @return string|null
     */
    public function getIso3_code()
    {
        return $this->iso3_code;
    }
    /**
     * Set iso3_code value
     * @param string $iso3_code
     * @return \App\Api\Client\Magento\Type\StructType\DirectoryCountryEntity
     */
    public function setIso3_code($iso3_code = null)
    {
        // validation for constraint: string
        if (!is_null($iso3_code) && !is_string($iso3_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso3_code)), __LINE__);
        }
        $this->iso3_code = $iso3_code;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Api\Client\Magento\Type\StructType\DirectoryCountryEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\DirectoryCountryEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
