<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerGroupEntity StructType
 * @subpackage Structs
 */
class CustomerGroupEntity extends AbstractStructBase
{
    /**
     * The customer_group_id
     * @var int
     */
    public $customer_group_id;
    /**
     * The customer_group_code
     * @var string
     */
    public $customer_group_code;
    /**
     * Constructor method for customerGroupEntity
     * @uses CustomerGroupEntity::setCustomer_group_id()
     * @uses CustomerGroupEntity::setCustomer_group_code()
     * @param int $customer_group_id
     * @param string $customer_group_code
     */
    public function __construct($customer_group_id = null, $customer_group_code = null)
    {
        $this
            ->setCustomer_group_id($customer_group_id)
            ->setCustomer_group_code($customer_group_code);
    }
    /**
     * Get customer_group_id value
     * @return int|null
     */
    public function getCustomer_group_id()
    {
        return $this->customer_group_id;
    }
    /**
     * Set customer_group_id value
     * @param int $customer_group_id
     * @return \App\Api\Client\Magento\Type\StructType\CustomerGroupEntity
     */
    public function setCustomer_group_id($customer_group_id = null)
    {
        // validation for constraint: int
        if (!is_null($customer_group_id) && !is_numeric($customer_group_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer_group_id)), __LINE__);
        }
        $this->customer_group_id = $customer_group_id;
        return $this;
    }
    /**
     * Get customer_group_code value
     * @return string|null
     */
    public function getCustomer_group_code()
    {
        return $this->customer_group_code;
    }
    /**
     * Set customer_group_code value
     * @param string $customer_group_code
     * @return \App\Api\Client\Magento\Type\StructType\CustomerGroupEntity
     */
    public function setCustomer_group_code($customer_group_code = null)
    {
        // validation for constraint: string
        if (!is_null($customer_group_code) && !is_string($customer_group_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_group_code)), __LINE__);
        }
        $this->customer_group_code = $customer_group_code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CustomerGroupEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
