<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerCustomerCreateRequestParam StructType
 * @subpackage Structs
 */
class CustomerCustomerCreateRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The customerData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\StructType\CustomerCustomerEntityToCreate
     */
    public $customerData;
    /**
     * Constructor method for customerCustomerCreateRequestParam
     * @uses CustomerCustomerCreateRequestParam::setSessionId()
     * @uses CustomerCustomerCreateRequestParam::setCustomerData()
     * @param string $sessionId
     * @param \App\Api\Client\Magento\Type\StructType\CustomerCustomerEntityToCreate $customerData
     */
    public function __construct($sessionId = null, \App\Api\Client\Magento\Type\StructType\CustomerCustomerEntityToCreate $customerData = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setCustomerData($customerData);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CustomerCustomerCreateRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get customerData value
     * @return \App\Api\Client\Magento\Type\StructType\CustomerCustomerEntityToCreate
     */
    public function getCustomerData()
    {
        return $this->customerData;
    }
    /**
     * Set customerData value
     * @param \App\Api\Client\Magento\Type\StructType\CustomerCustomerEntityToCreate $customerData
     * @return \App\Api\Client\Magento\Type\StructType\CustomerCustomerCreateRequestParam
     */
    public function setCustomerData(\App\Api\Client\Magento\Type\StructType\CustomerCustomerEntityToCreate $customerData = null)
    {
        $this->customerData = $customerData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CustomerCustomerCreateRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
