<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerAddressUpdateRequestParam StructType
 * @subpackage Structs
 */
class CustomerAddressUpdateRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The addressId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $addressId;
    /**
     * The addressData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public $addressData;
    /**
     * Constructor method for customerAddressUpdateRequestParam
     * @uses CustomerAddressUpdateRequestParam::setSessionId()
     * @uses CustomerAddressUpdateRequestParam::setAddressId()
     * @uses CustomerAddressUpdateRequestParam::setAddressData()
     * @param string $sessionId
     * @param int $addressId
     * @param \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate $addressData
     */
    public function __construct($sessionId = null, $addressId = null, \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate $addressData = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setAddressId($addressId)
            ->setAddressData($addressData);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressUpdateRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get addressId value
     * @return int
     */
    public function getAddressId()
    {
        return $this->addressId;
    }
    /**
     * Set addressId value
     * @param int $addressId
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressUpdateRequestParam
     */
    public function setAddressId($addressId = null)
    {
        // validation for constraint: int
        if (!is_null($addressId) && !is_numeric($addressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($addressId)), __LINE__);
        }
        $this->addressId = $addressId;
        return $this;
    }
    /**
     * Get addressData value
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function getAddressData()
    {
        return $this->addressData;
    }
    /**
     * Set addressData value
     * @param \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate $addressData
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressUpdateRequestParam
     */
    public function setAddressData(\App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate $addressData = null)
    {
        $this->addressData = $addressData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressUpdateRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
