<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for complexFilter StructType
 * @subpackage Structs
 */
class ComplexFilter extends AbstractStructBase
{
    /**
     * The key
     * @var string
     */
    public $key;
    /**
     * The value
     * @var \App\Api\Client\Magento\Type\StructType\AssociativeEntity
     */
    public $value;
    /**
     * Constructor method for complexFilter
     * @uses ComplexFilter::setKey()
     * @uses ComplexFilter::setValue()
     * @param string $key
     * @param \App\Api\Client\Magento\Type\StructType\AssociativeEntity $value
     */
    public function __construct($key = null, \App\Api\Client\Magento\Type\StructType\AssociativeEntity $value = null)
    {
        $this
            ->setKey($key)
            ->setValue($value);
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \App\Api\Client\Magento\Type\StructType\ComplexFilter
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get value value
     * @return \App\Api\Client\Magento\Type\StructType\AssociativeEntity|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param \App\Api\Client\Magento\Type\StructType\AssociativeEntity $value
     * @return \App\Api\Client\Magento\Type\StructType\ComplexFilter
     */
    public function setValue(\App\Api\Client\Magento\Type\StructType\AssociativeEntity $value = null)
    {
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ComplexFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
