<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductTierPriceEntity StructType
 * @subpackage Structs
 */
class CatalogProductTierPriceEntity extends AbstractStructBase
{
    /**
     * The customer_group_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_group_id;
    /**
     * The website
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $website;
    /**
     * The qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $qty;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * Constructor method for catalogProductTierPriceEntity
     * @uses CatalogProductTierPriceEntity::setCustomer_group_id()
     * @uses CatalogProductTierPriceEntity::setWebsite()
     * @uses CatalogProductTierPriceEntity::setQty()
     * @uses CatalogProductTierPriceEntity::setPrice()
     * @param string $customer_group_id
     * @param string $website
     * @param int $qty
     * @param float $price
     */
    public function __construct($customer_group_id = null, $website = null, $qty = null, $price = null)
    {
        $this
            ->setCustomer_group_id($customer_group_id)
            ->setWebsite($website)
            ->setQty($qty)
            ->setPrice($price);
    }
    /**
     * Get customer_group_id value
     * @return string|null
     */
    public function getCustomer_group_id()
    {
        return $this->customer_group_id;
    }
    /**
     * Set customer_group_id value
     * @param string $customer_group_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTierPriceEntity
     */
    public function setCustomer_group_id($customer_group_id = null)
    {
        // validation for constraint: string
        if (!is_null($customer_group_id) && !is_string($customer_group_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_group_id)), __LINE__);
        }
        $this->customer_group_id = $customer_group_id;
        return $this;
    }
    /**
     * Get website value
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->website;
    }
    /**
     * Set website value
     * @param string $website
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTierPriceEntity
     */
    public function setWebsite($website = null)
    {
        // validation for constraint: string
        if (!is_null($website) && !is_string($website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($website)), __LINE__);
        }
        $this->website = $website;
        return $this;
    }
    /**
     * Get qty value
     * @return int|null
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param int $qty
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTierPriceEntity
     */
    public function setQty($qty = null)
    {
        // validation for constraint: int
        if (!is_null($qty) && !is_numeric($qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($qty)), __LINE__);
        }
        $this->qty = $qty;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTierPriceEntity
     */
    public function setPrice($price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTierPriceEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
