<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductSetSpecialPriceRequestParam StructType
 * @subpackage Structs
 */
class CatalogProductSetSpecialPriceRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $productId;
    /**
     * The specialPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $specialPrice;
    /**
     * The fromDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fromDate;
    /**
     * The toDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $toDate;
    /**
     * The store
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $store;
    /**
     * Constructor method for catalogProductSetSpecialPriceRequestParam
     * @uses CatalogProductSetSpecialPriceRequestParam::setSessionId()
     * @uses CatalogProductSetSpecialPriceRequestParam::setProductId()
     * @uses CatalogProductSetSpecialPriceRequestParam::setSpecialPrice()
     * @uses CatalogProductSetSpecialPriceRequestParam::setFromDate()
     * @uses CatalogProductSetSpecialPriceRequestParam::setToDate()
     * @uses CatalogProductSetSpecialPriceRequestParam::setStore()
     * @param string $sessionId
     * @param string $productId
     * @param string $specialPrice
     * @param string $fromDate
     * @param string $toDate
     * @param string $store
     */
    public function __construct($sessionId = null, $productId = null, $specialPrice = null, $fromDate = null, $toDate = null, $store = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setProductId($productId)
            ->setSpecialPrice($specialPrice)
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setStore($store);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductSetSpecialPriceRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get productId value
     * @return string
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductSetSpecialPriceRequestParam
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get specialPrice value
     * @return string|null
     */
    public function getSpecialPrice()
    {
        return $this->specialPrice;
    }
    /**
     * Set specialPrice value
     * @param string $specialPrice
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductSetSpecialPriceRequestParam
     */
    public function setSpecialPrice($specialPrice = null)
    {
        // validation for constraint: string
        if (!is_null($specialPrice) && !is_string($specialPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($specialPrice)), __LINE__);
        }
        $this->specialPrice = $specialPrice;
        return $this;
    }
    /**
     * Get fromDate value
     * @return string|null
     */
    public function getFromDate()
    {
        return $this->fromDate;
    }
    /**
     * Set fromDate value
     * @param string $fromDate
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductSetSpecialPriceRequestParam
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDate)), __LINE__);
        }
        $this->fromDate = $fromDate;
        return $this;
    }
    /**
     * Get toDate value
     * @return string|null
     */
    public function getToDate()
    {
        return $this->toDate;
    }
    /**
     * Set toDate value
     * @param string $toDate
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductSetSpecialPriceRequestParam
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toDate)), __LINE__);
        }
        $this->toDate = $toDate;
        return $this;
    }
    /**
     * Get store value
     * @return string|null
     */
    public function getStore()
    {
        return $this->store;
    }
    /**
     * Set store value
     * @param string $store
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductSetSpecialPriceRequestParam
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        $this->store = $store;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductSetSpecialPriceRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
