<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductLinkEntity StructType
 * @subpackage Structs
 */
class CatalogProductLinkEntity extends AbstractStructBase
{
    /**
     * The product_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $product_id;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The set
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $set;
    /**
     * The sku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sku;
    /**
     * The position
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $position;
    /**
     * The qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $qty;
    /**
     * Constructor method for catalogProductLinkEntity
     * @uses CatalogProductLinkEntity::setProduct_id()
     * @uses CatalogProductLinkEntity::setType()
     * @uses CatalogProductLinkEntity::setSet()
     * @uses CatalogProductLinkEntity::setSku()
     * @uses CatalogProductLinkEntity::setPosition()
     * @uses CatalogProductLinkEntity::setQty()
     * @param string $product_id
     * @param string $type
     * @param string $set
     * @param string $sku
     * @param string $position
     * @param string $qty
     */
    public function __construct($product_id = null, $type = null, $set = null, $sku = null, $position = null, $qty = null)
    {
        $this
            ->setProduct_id($product_id)
            ->setType($type)
            ->setSet($set)
            ->setSku($sku)
            ->setPosition($position)
            ->setQty($qty);
    }
    /**
     * Get product_id value
     * @return string|null
     */
    public function getProduct_id()
    {
        return $this->product_id;
    }
    /**
     * Set product_id value
     * @param string $product_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkEntity
     */
    public function setProduct_id($product_id = null)
    {
        // validation for constraint: string
        if (!is_null($product_id) && !is_string($product_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product_id)), __LINE__);
        }
        $this->product_id = $product_id;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkEntity
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get set value
     * @return string|null
     */
    public function getSet()
    {
        return $this->set;
    }
    /**
     * Set set value
     * @param string $set
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkEntity
     */
    public function setSet($set = null)
    {
        // validation for constraint: string
        if (!is_null($set) && !is_string($set)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($set)), __LINE__);
        }
        $this->set = $set;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkEntity
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Get position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param string $position
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkEntity
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($position)), __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Get qty value
     * @return string|null
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param string $qty
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkEntity
     */
    public function setQty($qty = null)
    {
        // validation for constraint: string
        if (!is_null($qty) && !is_string($qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qty)), __LINE__);
        }
        $this->qty = $qty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
