<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductInfoRequestParam StructType
 * @subpackage Structs
 */
class CatalogProductInfoRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $productId;
    /**
     * The store
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $store;
    /**
     * The attributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\StructType\CatalogProductRequestAttributes
     */
    public $attributes;
    /**
     * The identifierType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identifierType;
    /**
     * Constructor method for catalogProductInfoRequestParam
     * @uses CatalogProductInfoRequestParam::setSessionId()
     * @uses CatalogProductInfoRequestParam::setProductId()
     * @uses CatalogProductInfoRequestParam::setStore()
     * @uses CatalogProductInfoRequestParam::setAttributes()
     * @uses CatalogProductInfoRequestParam::setIdentifierType()
     * @param string $sessionId
     * @param string $productId
     * @param string $store
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductRequestAttributes $attributes
     * @param string $identifierType
     */
    public function __construct($sessionId = null, $productId = null, $store = null, \App\Api\Client\Magento\Type\StructType\CatalogProductRequestAttributes $attributes = null, $identifierType = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setProductId($productId)
            ->setStore($store)
            ->setAttributes($attributes)
            ->setIdentifierType($identifierType);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductInfoRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get productId value
     * @return string
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductInfoRequestParam
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get store value
     * @return string|null
     */
    public function getStore()
    {
        return $this->store;
    }
    /**
     * Set store value
     * @param string $store
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductInfoRequestParam
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        $this->store = $store;
        return $this;
    }
    /**
     * Get attributes value
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductRequestAttributes|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductRequestAttributes $attributes
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductInfoRequestParam
     */
    public function setAttributes(\App\Api\Client\Magento\Type\StructType\CatalogProductRequestAttributes $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get identifierType value
     * @return string|null
     */
    public function getIdentifierType()
    {
        return $this->identifierType;
    }
    /**
     * Set identifierType value
     * @param string $identifierType
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductInfoRequestParam
     */
    public function setIdentifierType($identifierType = null)
    {
        // validation for constraint: string
        if (!is_null($identifierType) && !is_string($identifierType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifierType)), __LINE__);
        }
        $this->identifierType = $identifierType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductInfoRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
