<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductEntity StructType
 * @subpackage Structs
 */
class CatalogProductEntity extends AbstractStructBase
{
    /**
     * The product_id
     * @var string
     */
    public $product_id;
    /**
     * The sku
     * @var string
     */
    public $sku;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The set
     * @var string
     */
    public $set;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The category_ids
     * @var \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public $category_ids;
    /**
     * The website_ids
     * @var \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public $website_ids;
    /**
     * Constructor method for catalogProductEntity
     * @uses CatalogProductEntity::setProduct_id()
     * @uses CatalogProductEntity::setSku()
     * @uses CatalogProductEntity::setName()
     * @uses CatalogProductEntity::setSet()
     * @uses CatalogProductEntity::setType()
     * @uses CatalogProductEntity::setCategory_ids()
     * @uses CatalogProductEntity::setWebsite_ids()
     * @param string $product_id
     * @param string $sku
     * @param string $name
     * @param string $set
     * @param string $type
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $category_ids
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $website_ids
     */
    public function __construct($product_id = null, $sku = null, $name = null, $set = null, $type = null, \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $category_ids = null, \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $website_ids = null)
    {
        $this
            ->setProduct_id($product_id)
            ->setSku($sku)
            ->setName($name)
            ->setSet($set)
            ->setType($type)
            ->setCategory_ids($category_ids)
            ->setWebsite_ids($website_ids);
    }
    /**
     * Get product_id value
     * @return string|null
     */
    public function getProduct_id()
    {
        return $this->product_id;
    }
    /**
     * Set product_id value
     * @param string $product_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductEntity
     */
    public function setProduct_id($product_id = null)
    {
        // validation for constraint: string
        if (!is_null($product_id) && !is_string($product_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product_id)), __LINE__);
        }
        $this->product_id = $product_id;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductEntity
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get set value
     * @return string|null
     */
    public function getSet()
    {
        return $this->set;
    }
    /**
     * Set set value
     * @param string $set
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductEntity
     */
    public function setSet($set = null)
    {
        // validation for constraint: string
        if (!is_null($set) && !is_string($set)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($set)), __LINE__);
        }
        $this->set = $set;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductEntity
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get category_ids value
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfString|null
     */
    public function getCategory_ids()
    {
        return $this->category_ids;
    }
    /**
     * Set category_ids value
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $category_ids
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductEntity
     */
    public function setCategory_ids(\App\Api\Client\Magento\Type\ArrayType\ArrayOfString $category_ids = null)
    {
        $this->category_ids = $category_ids;
        return $this;
    }
    /**
     * Get website_ids value
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfString|null
     */
    public function getWebsite_ids()
    {
        return $this->website_ids;
    }
    /**
     * Set website_ids value
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $website_ids
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductEntity
     */
    public function setWebsite_ids(\App\Api\Client\Magento\Type\ArrayType\ArrayOfString $website_ids = null)
    {
        $this->website_ids = $website_ids;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
