<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductDownloadableLinkSampleEntity StructType
 * @subpackage Structs
 */
class CatalogProductDownloadableLinkSampleEntity extends AbstractStructBase
{
    /**
     * The sample_id
     * @var string
     */
    public $sample_id;
    /**
     * The product_id
     * @var string
     */
    public $product_id;
    /**
     * The sample_file
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sample_file;
    /**
     * The sample_url
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sample_url;
    /**
     * The sample_type
     * @var string
     */
    public $sample_type;
    /**
     * The sort_order
     * @var string
     */
    public $sort_order;
    /**
     * The default_title
     * @var string
     */
    public $default_title;
    /**
     * The store_title
     * @var string
     */
    public $store_title;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * Constructor method for catalogProductDownloadableLinkSampleEntity
     * @uses CatalogProductDownloadableLinkSampleEntity::setSample_id()
     * @uses CatalogProductDownloadableLinkSampleEntity::setProduct_id()
     * @uses CatalogProductDownloadableLinkSampleEntity::setSample_file()
     * @uses CatalogProductDownloadableLinkSampleEntity::setSample_url()
     * @uses CatalogProductDownloadableLinkSampleEntity::setSample_type()
     * @uses CatalogProductDownloadableLinkSampleEntity::setSort_order()
     * @uses CatalogProductDownloadableLinkSampleEntity::setDefault_title()
     * @uses CatalogProductDownloadableLinkSampleEntity::setStore_title()
     * @uses CatalogProductDownloadableLinkSampleEntity::setTitle()
     * @param string $sample_id
     * @param string $product_id
     * @param string $sample_file
     * @param string $sample_url
     * @param string $sample_type
     * @param string $sort_order
     * @param string $default_title
     * @param string $store_title
     * @param string $title
     */
    public function __construct($sample_id = null, $product_id = null, $sample_file = null, $sample_url = null, $sample_type = null, $sort_order = null, $default_title = null, $store_title = null, $title = null)
    {
        $this
            ->setSample_id($sample_id)
            ->setProduct_id($product_id)
            ->setSample_file($sample_file)
            ->setSample_url($sample_url)
            ->setSample_type($sample_type)
            ->setSort_order($sort_order)
            ->setDefault_title($default_title)
            ->setStore_title($store_title)
            ->setTitle($title);
    }
    /**
     * Get sample_id value
     * @return string|null
     */
    public function getSample_id()
    {
        return $this->sample_id;
    }
    /**
     * Set sample_id value
     * @param string $sample_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkSampleEntity
     */
    public function setSample_id($sample_id = null)
    {
        // validation for constraint: string
        if (!is_null($sample_id) && !is_string($sample_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sample_id)), __LINE__);
        }
        $this->sample_id = $sample_id;
        return $this;
    }
    /**
     * Get product_id value
     * @return string|null
     */
    public function getProduct_id()
    {
        return $this->product_id;
    }
    /**
     * Set product_id value
     * @param string $product_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkSampleEntity
     */
    public function setProduct_id($product_id = null)
    {
        // validation for constraint: string
        if (!is_null($product_id) && !is_string($product_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product_id)), __LINE__);
        }
        $this->product_id = $product_id;
        return $this;
    }
    /**
     * Get sample_file value
     * @return string|null
     */
    public function getSample_file()
    {
        return $this->sample_file;
    }
    /**
     * Set sample_file value
     * @param string $sample_file
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkSampleEntity
     */
    public function setSample_file($sample_file = null)
    {
        // validation for constraint: string
        if (!is_null($sample_file) && !is_string($sample_file)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sample_file)), __LINE__);
        }
        $this->sample_file = $sample_file;
        return $this;
    }
    /**
     * Get sample_url value
     * @return string|null
     */
    public function getSample_url()
    {
        return $this->sample_url;
    }
    /**
     * Set sample_url value
     * @param string $sample_url
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkSampleEntity
     */
    public function setSample_url($sample_url = null)
    {
        // validation for constraint: string
        if (!is_null($sample_url) && !is_string($sample_url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sample_url)), __LINE__);
        }
        $this->sample_url = $sample_url;
        return $this;
    }
    /**
     * Get sample_type value
     * @return string|null
     */
    public function getSample_type()
    {
        return $this->sample_type;
    }
    /**
     * Set sample_type value
     * @param string $sample_type
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkSampleEntity
     */
    public function setSample_type($sample_type = null)
    {
        // validation for constraint: string
        if (!is_null($sample_type) && !is_string($sample_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sample_type)), __LINE__);
        }
        $this->sample_type = $sample_type;
        return $this;
    }
    /**
     * Get sort_order value
     * @return string|null
     */
    public function getSort_order()
    {
        return $this->sort_order;
    }
    /**
     * Set sort_order value
     * @param string $sort_order
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkSampleEntity
     */
    public function setSort_order($sort_order = null)
    {
        // validation for constraint: string
        if (!is_null($sort_order) && !is_string($sort_order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sort_order)), __LINE__);
        }
        $this->sort_order = $sort_order;
        return $this;
    }
    /**
     * Get default_title value
     * @return string|null
     */
    public function getDefault_title()
    {
        return $this->default_title;
    }
    /**
     * Set default_title value
     * @param string $default_title
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkSampleEntity
     */
    public function setDefault_title($default_title = null)
    {
        // validation for constraint: string
        if (!is_null($default_title) && !is_string($default_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($default_title)), __LINE__);
        }
        $this->default_title = $default_title;
        return $this;
    }
    /**
     * Get store_title value
     * @return string|null
     */
    public function getStore_title()
    {
        return $this->store_title;
    }
    /**
     * Set store_title value
     * @param string $store_title
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkSampleEntity
     */
    public function setStore_title($store_title = null)
    {
        // validation for constraint: string
        if (!is_null($store_title) && !is_string($store_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store_title)), __LINE__);
        }
        $this->store_title = $store_title;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkSampleEntity
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkSampleEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
