<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductDownloadableLinkAddEntity StructType
 * @subpackage Structs
 */
class CatalogProductDownloadableLinkAddEntity extends AbstractStructBase
{
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $title;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $price;
    /**
     * The is_unlimited
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_unlimited;
    /**
     * The number_of_downloads
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $number_of_downloads;
    /**
     * The is_shareable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_shareable;
    /**
     * The sample
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddSampleEntity
     */
    public $sample;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The file
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkFileEntity
     */
    public $file;
    /**
     * The link_url
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $link_url;
    /**
     * The sample_url
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sample_url;
    /**
     * The sort_order
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sort_order;
    /**
     * Constructor method for catalogProductDownloadableLinkAddEntity
     * @uses CatalogProductDownloadableLinkAddEntity::setTitle()
     * @uses CatalogProductDownloadableLinkAddEntity::setPrice()
     * @uses CatalogProductDownloadableLinkAddEntity::setIs_unlimited()
     * @uses CatalogProductDownloadableLinkAddEntity::setNumber_of_downloads()
     * @uses CatalogProductDownloadableLinkAddEntity::setIs_shareable()
     * @uses CatalogProductDownloadableLinkAddEntity::setSample()
     * @uses CatalogProductDownloadableLinkAddEntity::setType()
     * @uses CatalogProductDownloadableLinkAddEntity::setFile()
     * @uses CatalogProductDownloadableLinkAddEntity::setLink_url()
     * @uses CatalogProductDownloadableLinkAddEntity::setSample_url()
     * @uses CatalogProductDownloadableLinkAddEntity::setSort_order()
     * @param string $title
     * @param string $price
     * @param int $is_unlimited
     * @param int $number_of_downloads
     * @param int $is_shareable
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddSampleEntity $sample
     * @param string $type
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkFileEntity $file
     * @param string $link_url
     * @param string $sample_url
     * @param int $sort_order
     */
    public function __construct($title = null, $price = null, $is_unlimited = null, $number_of_downloads = null, $is_shareable = null, \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddSampleEntity $sample = null, $type = null, \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkFileEntity $file = null, $link_url = null, $sample_url = null, $sort_order = null)
    {
        $this
            ->setTitle($title)
            ->setPrice($price)
            ->setIs_unlimited($is_unlimited)
            ->setNumber_of_downloads($number_of_downloads)
            ->setIs_shareable($is_shareable)
            ->setSample($sample)
            ->setType($type)
            ->setFile($file)
            ->setLink_url($link_url)
            ->setSample_url($sample_url)
            ->setSort_order($sort_order);
    }
    /**
     * Get title value
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddEntity
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get price value
     * @return string|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param string $price
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddEntity
     */
    public function setPrice($price = null)
    {
        // validation for constraint: string
        if (!is_null($price) && !is_string($price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get is_unlimited value
     * @return int|null
     */
    public function getIs_unlimited()
    {
        return $this->is_unlimited;
    }
    /**
     * Set is_unlimited value
     * @param int $is_unlimited
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddEntity
     */
    public function setIs_unlimited($is_unlimited = null)
    {
        // validation for constraint: int
        if (!is_null($is_unlimited) && !is_numeric($is_unlimited)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_unlimited)), __LINE__);
        }
        $this->is_unlimited = $is_unlimited;
        return $this;
    }
    /**
     * Get number_of_downloads value
     * @return int|null
     */
    public function getNumber_of_downloads()
    {
        return $this->number_of_downloads;
    }
    /**
     * Set number_of_downloads value
     * @param int $number_of_downloads
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddEntity
     */
    public function setNumber_of_downloads($number_of_downloads = null)
    {
        // validation for constraint: int
        if (!is_null($number_of_downloads) && !is_numeric($number_of_downloads)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($number_of_downloads)), __LINE__);
        }
        $this->number_of_downloads = $number_of_downloads;
        return $this;
    }
    /**
     * Get is_shareable value
     * @return int|null
     */
    public function getIs_shareable()
    {
        return $this->is_shareable;
    }
    /**
     * Set is_shareable value
     * @param int $is_shareable
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddEntity
     */
    public function setIs_shareable($is_shareable = null)
    {
        // validation for constraint: int
        if (!is_null($is_shareable) && !is_numeric($is_shareable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_shareable)), __LINE__);
        }
        $this->is_shareable = $is_shareable;
        return $this;
    }
    /**
     * Get sample value
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddSampleEntity|null
     */
    public function getSample()
    {
        return $this->sample;
    }
    /**
     * Set sample value
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddSampleEntity $sample
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddEntity
     */
    public function setSample(\App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddSampleEntity $sample = null)
    {
        $this->sample = $sample;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddEntity
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get file value
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkFileEntity|null
     */
    public function getFile()
    {
        return $this->file;
    }
    /**
     * Set file value
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkFileEntity $file
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddEntity
     */
    public function setFile(\App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkFileEntity $file = null)
    {
        $this->file = $file;
        return $this;
    }
    /**
     * Get link_url value
     * @return string|null
     */
    public function getLink_url()
    {
        return $this->link_url;
    }
    /**
     * Set link_url value
     * @param string $link_url
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddEntity
     */
    public function setLink_url($link_url = null)
    {
        // validation for constraint: string
        if (!is_null($link_url) && !is_string($link_url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($link_url)), __LINE__);
        }
        $this->link_url = $link_url;
        return $this;
    }
    /**
     * Get sample_url value
     * @return string|null
     */
    public function getSample_url()
    {
        return $this->sample_url;
    }
    /**
     * Set sample_url value
     * @param string $sample_url
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddEntity
     */
    public function setSample_url($sample_url = null)
    {
        // validation for constraint: string
        if (!is_null($sample_url) && !is_string($sample_url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sample_url)), __LINE__);
        }
        $this->sample_url = $sample_url;
        return $this;
    }
    /**
     * Get sort_order value
     * @return int|null
     */
    public function getSort_order()
    {
        return $this->sort_order;
    }
    /**
     * Set sort_order value
     * @param int $sort_order
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddEntity
     */
    public function setSort_order($sort_order = null)
    {
        // validation for constraint: int
        if (!is_null($sort_order) && !is_numeric($sort_order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sort_order)), __LINE__);
        }
        $this->sort_order = $sort_order;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
