<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductCreateRequestParam StructType
 * @subpackage Structs
 */
class CatalogProductCreateRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The set
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $set;
    /**
     * The sku
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sku;
    /**
     * The productData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\StructType\CatalogProductCreateEntity
     */
    public $productData;
    /**
     * The store
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $store;
    /**
     * Constructor method for catalogProductCreateRequestParam
     * @uses CatalogProductCreateRequestParam::setSessionId()
     * @uses CatalogProductCreateRequestParam::setType()
     * @uses CatalogProductCreateRequestParam::setSet()
     * @uses CatalogProductCreateRequestParam::setSku()
     * @uses CatalogProductCreateRequestParam::setProductData()
     * @uses CatalogProductCreateRequestParam::setStore()
     * @param string $sessionId
     * @param string $type
     * @param string $set
     * @param string $sku
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCreateEntity $productData
     * @param string $store
     */
    public function __construct($sessionId = null, $type = null, $set = null, $sku = null, \App\Api\Client\Magento\Type\StructType\CatalogProductCreateEntity $productData = null, $store = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setType($type)
            ->setSet($set)
            ->setSku($sku)
            ->setProductData($productData)
            ->setStore($store);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCreateRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCreateRequestParam
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get set value
     * @return string
     */
    public function getSet()
    {
        return $this->set;
    }
    /**
     * Set set value
     * @param string $set
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCreateRequestParam
     */
    public function setSet($set = null)
    {
        // validation for constraint: string
        if (!is_null($set) && !is_string($set)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($set)), __LINE__);
        }
        $this->set = $set;
        return $this;
    }
    /**
     * Get sku value
     * @return string
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCreateRequestParam
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Get productData value
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCreateEntity
     */
    public function getProductData()
    {
        return $this->productData;
    }
    /**
     * Set productData value
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCreateEntity $productData
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCreateRequestParam
     */
    public function setProductData(\App\Api\Client\Magento\Type\StructType\CatalogProductCreateEntity $productData = null)
    {
        $this->productData = $productData;
        return $this;
    }
    /**
     * Get store value
     * @return string|null
     */
    public function getStore()
    {
        return $this->store;
    }
    /**
     * Set store value
     * @param string $store
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCreateRequestParam
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        $this->store = $store;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCreateRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
