<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductAttributeSetEntity StructType
 * @subpackage Structs
 */
class CatalogProductAttributeSetEntity extends AbstractStructBase
{
    /**
     * The set_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $set_id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * Constructor method for catalogProductAttributeSetEntity
     * @uses CatalogProductAttributeSetEntity::setSet_id()
     * @uses CatalogProductAttributeSetEntity::setName()
     * @param int $set_id
     * @param string $name
     */
    public function __construct($set_id = null, $name = null)
    {
        $this
            ->setSet_id($set_id)
            ->setName($name);
    }
    /**
     * Get set_id value
     * @return int|null
     */
    public function getSet_id()
    {
        return $this->set_id;
    }
    /**
     * Set set_id value
     * @param int $set_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetEntity
     */
    public function setSet_id($set_id = null)
    {
        // validation for constraint: int
        if (!is_null($set_id) && !is_numeric($set_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($set_id)), __LINE__);
        }
        $this->set_id = $set_id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
