<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductAttributeListRequestParam StructType
 * @subpackage Structs
 */
class CatalogProductAttributeListRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The setId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $setId;
    /**
     * Constructor method for catalogProductAttributeListRequestParam
     * @uses CatalogProductAttributeListRequestParam::setSessionId()
     * @uses CatalogProductAttributeListRequestParam::setSetId()
     * @param string $sessionId
     * @param int $setId
     */
    public function __construct($sessionId = null, $setId = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setSetId($setId);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeListRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get setId value
     * @return int
     */
    public function getSetId()
    {
        return $this->setId;
    }
    /**
     * Set setId value
     * @param int $setId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeListRequestParam
     */
    public function setSetId($setId = null)
    {
        // validation for constraint: int
        if (!is_null($setId) && !is_numeric($setId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($setId)), __LINE__);
        }
        $this->setId = $setId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeListRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
