<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogInventoryStockItemUpdateRequestParam StructType
 * @subpackage Structs
 */
class CatalogInventoryStockItemUpdateRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $productId;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public $data;
    /**
     * Constructor method for catalogInventoryStockItemUpdateRequestParam
     * @uses CatalogInventoryStockItemUpdateRequestParam::setSessionId()
     * @uses CatalogInventoryStockItemUpdateRequestParam::setProductId()
     * @uses CatalogInventoryStockItemUpdateRequestParam::setData()
     * @param string $sessionId
     * @param string $productId
     * @param \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity $data
     */
    public function __construct($sessionId = null, $productId = null, \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity $data = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setProductId($productId)
            ->setData($data);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get productId value
     * @return string
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateRequestParam
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get data value
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity $data
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateRequestParam
     */
    public function setData(\App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity $data = null)
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
