<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogInventoryStockItemUpdateEntity StructType
 * @subpackage Structs
 */
class CatalogInventoryStockItemUpdateEntity extends AbstractStructBase
{
    /**
     * The qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $qty;
    /**
     * The is_in_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_in_stock;
    /**
     * The manage_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $manage_stock;
    /**
     * The use_config_manage_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $use_config_manage_stock;
    /**
     * The min_qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $min_qty;
    /**
     * The use_config_min_qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $use_config_min_qty;
    /**
     * The min_sale_qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $min_sale_qty;
    /**
     * The use_config_min_sale_qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $use_config_min_sale_qty;
    /**
     * The max_sale_qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $max_sale_qty;
    /**
     * The use_config_max_sale_qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $use_config_max_sale_qty;
    /**
     * The is_qty_decimal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_qty_decimal;
    /**
     * The backorders
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $backorders;
    /**
     * The use_config_backorders
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $use_config_backorders;
    /**
     * The notify_stock_qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $notify_stock_qty;
    /**
     * The use_config_notify_stock_qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $use_config_notify_stock_qty;
    /**
     * Constructor method for catalogInventoryStockItemUpdateEntity
     * @uses CatalogInventoryStockItemUpdateEntity::setQty()
     * @uses CatalogInventoryStockItemUpdateEntity::setIs_in_stock()
     * @uses CatalogInventoryStockItemUpdateEntity::setManage_stock()
     * @uses CatalogInventoryStockItemUpdateEntity::setUse_config_manage_stock()
     * @uses CatalogInventoryStockItemUpdateEntity::setMin_qty()
     * @uses CatalogInventoryStockItemUpdateEntity::setUse_config_min_qty()
     * @uses CatalogInventoryStockItemUpdateEntity::setMin_sale_qty()
     * @uses CatalogInventoryStockItemUpdateEntity::setUse_config_min_sale_qty()
     * @uses CatalogInventoryStockItemUpdateEntity::setMax_sale_qty()
     * @uses CatalogInventoryStockItemUpdateEntity::setUse_config_max_sale_qty()
     * @uses CatalogInventoryStockItemUpdateEntity::setIs_qty_decimal()
     * @uses CatalogInventoryStockItemUpdateEntity::setBackorders()
     * @uses CatalogInventoryStockItemUpdateEntity::setUse_config_backorders()
     * @uses CatalogInventoryStockItemUpdateEntity::setNotify_stock_qty()
     * @uses CatalogInventoryStockItemUpdateEntity::setUse_config_notify_stock_qty()
     * @param string $qty
     * @param int $is_in_stock
     * @param int $manage_stock
     * @param int $use_config_manage_stock
     * @param int $min_qty
     * @param int $use_config_min_qty
     * @param int $min_sale_qty
     * @param int $use_config_min_sale_qty
     * @param int $max_sale_qty
     * @param int $use_config_max_sale_qty
     * @param int $is_qty_decimal
     * @param int $backorders
     * @param int $use_config_backorders
     * @param int $notify_stock_qty
     * @param int $use_config_notify_stock_qty
     */
    public function __construct($qty = null, $is_in_stock = null, $manage_stock = null, $use_config_manage_stock = null, $min_qty = null, $use_config_min_qty = null, $min_sale_qty = null, $use_config_min_sale_qty = null, $max_sale_qty = null, $use_config_max_sale_qty = null, $is_qty_decimal = null, $backorders = null, $use_config_backorders = null, $notify_stock_qty = null, $use_config_notify_stock_qty = null)
    {
        $this
            ->setQty($qty)
            ->setIs_in_stock($is_in_stock)
            ->setManage_stock($manage_stock)
            ->setUse_config_manage_stock($use_config_manage_stock)
            ->setMin_qty($min_qty)
            ->setUse_config_min_qty($use_config_min_qty)
            ->setMin_sale_qty($min_sale_qty)
            ->setUse_config_min_sale_qty($use_config_min_sale_qty)
            ->setMax_sale_qty($max_sale_qty)
            ->setUse_config_max_sale_qty($use_config_max_sale_qty)
            ->setIs_qty_decimal($is_qty_decimal)
            ->setBackorders($backorders)
            ->setUse_config_backorders($use_config_backorders)
            ->setNotify_stock_qty($notify_stock_qty)
            ->setUse_config_notify_stock_qty($use_config_notify_stock_qty);
    }
    /**
     * Get qty value
     * @return string|null
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param string $qty
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setQty($qty = null)
    {
        // validation for constraint: string
        if (!is_null($qty) && !is_string($qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qty)), __LINE__);
        }
        $this->qty = $qty;
        return $this;
    }
    /**
     * Get is_in_stock value
     * @return int|null
     */
    public function getIs_in_stock()
    {
        return $this->is_in_stock;
    }
    /**
     * Set is_in_stock value
     * @param int $is_in_stock
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setIs_in_stock($is_in_stock = null)
    {
        // validation for constraint: int
        if (!is_null($is_in_stock) && !is_numeric($is_in_stock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_in_stock)), __LINE__);
        }
        $this->is_in_stock = $is_in_stock;
        return $this;
    }
    /**
     * Get manage_stock value
     * @return int|null
     */
    public function getManage_stock()
    {
        return $this->manage_stock;
    }
    /**
     * Set manage_stock value
     * @param int $manage_stock
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setManage_stock($manage_stock = null)
    {
        // validation for constraint: int
        if (!is_null($manage_stock) && !is_numeric($manage_stock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($manage_stock)), __LINE__);
        }
        $this->manage_stock = $manage_stock;
        return $this;
    }
    /**
     * Get use_config_manage_stock value
     * @return int|null
     */
    public function getUse_config_manage_stock()
    {
        return $this->use_config_manage_stock;
    }
    /**
     * Set use_config_manage_stock value
     * @param int $use_config_manage_stock
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setUse_config_manage_stock($use_config_manage_stock = null)
    {
        // validation for constraint: int
        if (!is_null($use_config_manage_stock) && !is_numeric($use_config_manage_stock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($use_config_manage_stock)), __LINE__);
        }
        $this->use_config_manage_stock = $use_config_manage_stock;
        return $this;
    }
    /**
     * Get min_qty value
     * @return int|null
     */
    public function getMin_qty()
    {
        return $this->min_qty;
    }
    /**
     * Set min_qty value
     * @param int $min_qty
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setMin_qty($min_qty = null)
    {
        // validation for constraint: int
        if (!is_null($min_qty) && !is_numeric($min_qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($min_qty)), __LINE__);
        }
        $this->min_qty = $min_qty;
        return $this;
    }
    /**
     * Get use_config_min_qty value
     * @return int|null
     */
    public function getUse_config_min_qty()
    {
        return $this->use_config_min_qty;
    }
    /**
     * Set use_config_min_qty value
     * @param int $use_config_min_qty
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setUse_config_min_qty($use_config_min_qty = null)
    {
        // validation for constraint: int
        if (!is_null($use_config_min_qty) && !is_numeric($use_config_min_qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($use_config_min_qty)), __LINE__);
        }
        $this->use_config_min_qty = $use_config_min_qty;
        return $this;
    }
    /**
     * Get min_sale_qty value
     * @return int|null
     */
    public function getMin_sale_qty()
    {
        return $this->min_sale_qty;
    }
    /**
     * Set min_sale_qty value
     * @param int $min_sale_qty
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setMin_sale_qty($min_sale_qty = null)
    {
        // validation for constraint: int
        if (!is_null($min_sale_qty) && !is_numeric($min_sale_qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($min_sale_qty)), __LINE__);
        }
        $this->min_sale_qty = $min_sale_qty;
        return $this;
    }
    /**
     * Get use_config_min_sale_qty value
     * @return int|null
     */
    public function getUse_config_min_sale_qty()
    {
        return $this->use_config_min_sale_qty;
    }
    /**
     * Set use_config_min_sale_qty value
     * @param int $use_config_min_sale_qty
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setUse_config_min_sale_qty($use_config_min_sale_qty = null)
    {
        // validation for constraint: int
        if (!is_null($use_config_min_sale_qty) && !is_numeric($use_config_min_sale_qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($use_config_min_sale_qty)), __LINE__);
        }
        $this->use_config_min_sale_qty = $use_config_min_sale_qty;
        return $this;
    }
    /**
     * Get max_sale_qty value
     * @return int|null
     */
    public function getMax_sale_qty()
    {
        return $this->max_sale_qty;
    }
    /**
     * Set max_sale_qty value
     * @param int $max_sale_qty
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setMax_sale_qty($max_sale_qty = null)
    {
        // validation for constraint: int
        if (!is_null($max_sale_qty) && !is_numeric($max_sale_qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($max_sale_qty)), __LINE__);
        }
        $this->max_sale_qty = $max_sale_qty;
        return $this;
    }
    /**
     * Get use_config_max_sale_qty value
     * @return int|null
     */
    public function getUse_config_max_sale_qty()
    {
        return $this->use_config_max_sale_qty;
    }
    /**
     * Set use_config_max_sale_qty value
     * @param int $use_config_max_sale_qty
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setUse_config_max_sale_qty($use_config_max_sale_qty = null)
    {
        // validation for constraint: int
        if (!is_null($use_config_max_sale_qty) && !is_numeric($use_config_max_sale_qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($use_config_max_sale_qty)), __LINE__);
        }
        $this->use_config_max_sale_qty = $use_config_max_sale_qty;
        return $this;
    }
    /**
     * Get is_qty_decimal value
     * @return int|null
     */
    public function getIs_qty_decimal()
    {
        return $this->is_qty_decimal;
    }
    /**
     * Set is_qty_decimal value
     * @param int $is_qty_decimal
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setIs_qty_decimal($is_qty_decimal = null)
    {
        // validation for constraint: int
        if (!is_null($is_qty_decimal) && !is_numeric($is_qty_decimal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_qty_decimal)), __LINE__);
        }
        $this->is_qty_decimal = $is_qty_decimal;
        return $this;
    }
    /**
     * Get backorders value
     * @return int|null
     */
    public function getBackorders()
    {
        return $this->backorders;
    }
    /**
     * Set backorders value
     * @param int $backorders
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setBackorders($backorders = null)
    {
        // validation for constraint: int
        if (!is_null($backorders) && !is_numeric($backorders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($backorders)), __LINE__);
        }
        $this->backorders = $backorders;
        return $this;
    }
    /**
     * Get use_config_backorders value
     * @return int|null
     */
    public function getUse_config_backorders()
    {
        return $this->use_config_backorders;
    }
    /**
     * Set use_config_backorders value
     * @param int $use_config_backorders
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setUse_config_backorders($use_config_backorders = null)
    {
        // validation for constraint: int
        if (!is_null($use_config_backorders) && !is_numeric($use_config_backorders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($use_config_backorders)), __LINE__);
        }
        $this->use_config_backorders = $use_config_backorders;
        return $this;
    }
    /**
     * Get notify_stock_qty value
     * @return int|null
     */
    public function getNotify_stock_qty()
    {
        return $this->notify_stock_qty;
    }
    /**
     * Set notify_stock_qty value
     * @param int $notify_stock_qty
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setNotify_stock_qty($notify_stock_qty = null)
    {
        // validation for constraint: int
        if (!is_null($notify_stock_qty) && !is_numeric($notify_stock_qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notify_stock_qty)), __LINE__);
        }
        $this->notify_stock_qty = $notify_stock_qty;
        return $this;
    }
    /**
     * Get use_config_notify_stock_qty value
     * @return int|null
     */
    public function getUse_config_notify_stock_qty()
    {
        return $this->use_config_notify_stock_qty;
    }
    /**
     * Set use_config_notify_stock_qty value
     * @param int $use_config_notify_stock_qty
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public function setUse_config_notify_stock_qty($use_config_notify_stock_qty = null)
    {
        // validation for constraint: int
        if (!is_null($use_config_notify_stock_qty) && !is_numeric($use_config_notify_stock_qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($use_config_notify_stock_qty)), __LINE__);
        }
        $this->use_config_notify_stock_qty = $use_config_notify_stock_qty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
