<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogCategoryMoveRequestParam StructType
 * @subpackage Structs
 */
class CatalogCategoryMoveRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The categoryId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $categoryId;
    /**
     * The parentId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $parentId;
    /**
     * The afterId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $afterId;
    /**
     * Constructor method for catalogCategoryMoveRequestParam
     * @uses CatalogCategoryMoveRequestParam::setSessionId()
     * @uses CatalogCategoryMoveRequestParam::setCategoryId()
     * @uses CatalogCategoryMoveRequestParam::setParentId()
     * @uses CatalogCategoryMoveRequestParam::setAfterId()
     * @param string $sessionId
     * @param int $categoryId
     * @param int $parentId
     * @param string $afterId
     */
    public function __construct($sessionId = null, $categoryId = null, $parentId = null, $afterId = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setCategoryId($categoryId)
            ->setParentId($parentId)
            ->setAfterId($afterId);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryMoveRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get categoryId value
     * @return int
     */
    public function getCategoryId()
    {
        return $this->categoryId;
    }
    /**
     * Set categoryId value
     * @param int $categoryId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryMoveRequestParam
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !is_numeric($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryId)), __LINE__);
        }
        $this->categoryId = $categoryId;
        return $this;
    }
    /**
     * Get parentId value
     * @return int
     */
    public function getParentId()
    {
        return $this->parentId;
    }
    /**
     * Set parentId value
     * @param int $parentId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryMoveRequestParam
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: int
        if (!is_null($parentId) && !is_numeric($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parentId)), __LINE__);
        }
        $this->parentId = $parentId;
        return $this;
    }
    /**
     * Get afterId value
     * @return string
     */
    public function getAfterId()
    {
        return $this->afterId;
    }
    /**
     * Set afterId value
     * @param string $afterId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryMoveRequestParam
     */
    public function setAfterId($afterId = null)
    {
        // validation for constraint: string
        if (!is_null($afterId) && !is_string($afterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($afterId)), __LINE__);
        }
        $this->afterId = $afterId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryMoveRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
