<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogCategoryInfo StructType
 * @subpackage Structs
 */
class CatalogCategoryInfo extends AbstractStructBase
{
    /**
     * The category_id
     * @var string
     */
    public $category_id;
    /**
     * The is_active
     * @var int
     */
    public $is_active;
    /**
     * The position
     * @var string
     */
    public $position;
    /**
     * The level
     * @var string
     */
    public $level;
    /**
     * The parent_id
     * @var string
     */
    public $parent_id;
    /**
     * The all_children
     * @var string
     */
    public $all_children;
    /**
     * The children
     * @var string
     */
    public $children;
    /**
     * The created_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $created_at;
    /**
     * The updated_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $updated_at;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The url_key
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url_key;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The meta_title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $meta_title;
    /**
     * The meta_keywords
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $meta_keywords;
    /**
     * The meta_description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $meta_description;
    /**
     * The path
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $path;
    /**
     * The url_path
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url_path;
    /**
     * The children_count
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $children_count;
    /**
     * The display_mode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $display_mode;
    /**
     * The is_anchor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_anchor;
    /**
     * The available_sort_by
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public $available_sort_by;
    /**
     * The custom_design
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $custom_design;
    /**
     * The custom_design_apply
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $custom_design_apply;
    /**
     * The custom_design_from
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $custom_design_from;
    /**
     * The custom_design_to
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $custom_design_to;
    /**
     * The page_layout
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $page_layout;
    /**
     * The custom_layout_update
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $custom_layout_update;
    /**
     * The default_sort_by
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $default_sort_by;
    /**
     * The landing_page
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $landing_page;
    /**
     * The include_in_menu
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $include_in_menu;
    /**
     * The custom_use_parent_settings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $custom_use_parent_settings;
    /**
     * The custom_apply_to_products
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $custom_apply_to_products;
    /**
     * The filter_price_range
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $filter_price_range;
    /**
     * Constructor method for catalogCategoryInfo
     * @uses CatalogCategoryInfo::setCategory_id()
     * @uses CatalogCategoryInfo::setIs_active()
     * @uses CatalogCategoryInfo::setPosition()
     * @uses CatalogCategoryInfo::setLevel()
     * @uses CatalogCategoryInfo::setParent_id()
     * @uses CatalogCategoryInfo::setAll_children()
     * @uses CatalogCategoryInfo::setChildren()
     * @uses CatalogCategoryInfo::setCreated_at()
     * @uses CatalogCategoryInfo::setUpdated_at()
     * @uses CatalogCategoryInfo::setName()
     * @uses CatalogCategoryInfo::setUrl_key()
     * @uses CatalogCategoryInfo::setDescription()
     * @uses CatalogCategoryInfo::setMeta_title()
     * @uses CatalogCategoryInfo::setMeta_keywords()
     * @uses CatalogCategoryInfo::setMeta_description()
     * @uses CatalogCategoryInfo::setPath()
     * @uses CatalogCategoryInfo::setUrl_path()
     * @uses CatalogCategoryInfo::setChildren_count()
     * @uses CatalogCategoryInfo::setDisplay_mode()
     * @uses CatalogCategoryInfo::setIs_anchor()
     * @uses CatalogCategoryInfo::setAvailable_sort_by()
     * @uses CatalogCategoryInfo::setCustom_design()
     * @uses CatalogCategoryInfo::setCustom_design_apply()
     * @uses CatalogCategoryInfo::setCustom_design_from()
     * @uses CatalogCategoryInfo::setCustom_design_to()
     * @uses CatalogCategoryInfo::setPage_layout()
     * @uses CatalogCategoryInfo::setCustom_layout_update()
     * @uses CatalogCategoryInfo::setDefault_sort_by()
     * @uses CatalogCategoryInfo::setLanding_page()
     * @uses CatalogCategoryInfo::setInclude_in_menu()
     * @uses CatalogCategoryInfo::setCustom_use_parent_settings()
     * @uses CatalogCategoryInfo::setCustom_apply_to_products()
     * @uses CatalogCategoryInfo::setFilter_price_range()
     * @param string $category_id
     * @param int $is_active
     * @param string $position
     * @param string $level
     * @param string $parent_id
     * @param string $all_children
     * @param string $children
     * @param string $created_at
     * @param string $updated_at
     * @param string $name
     * @param string $url_key
     * @param string $description
     * @param string $meta_title
     * @param string $meta_keywords
     * @param string $meta_description
     * @param string $path
     * @param string $url_path
     * @param int $children_count
     * @param string $display_mode
     * @param int $is_anchor
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $available_sort_by
     * @param string $custom_design
     * @param string $custom_design_apply
     * @param string $custom_design_from
     * @param string $custom_design_to
     * @param string $page_layout
     * @param string $custom_layout_update
     * @param string $default_sort_by
     * @param int $landing_page
     * @param int $include_in_menu
     * @param int $custom_use_parent_settings
     * @param int $custom_apply_to_products
     * @param string $filter_price_range
     */
    public function __construct($category_id = null, $is_active = null, $position = null, $level = null, $parent_id = null, $all_children = null, $children = null, $created_at = null, $updated_at = null, $name = null, $url_key = null, $description = null, $meta_title = null, $meta_keywords = null, $meta_description = null, $path = null, $url_path = null, $children_count = null, $display_mode = null, $is_anchor = null, \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $available_sort_by = null, $custom_design = null, $custom_design_apply = null, $custom_design_from = null, $custom_design_to = null, $page_layout = null, $custom_layout_update = null, $default_sort_by = null, $landing_page = null, $include_in_menu = null, $custom_use_parent_settings = null, $custom_apply_to_products = null, $filter_price_range = null)
    {
        $this
            ->setCategory_id($category_id)
            ->setIs_active($is_active)
            ->setPosition($position)
            ->setLevel($level)
            ->setParent_id($parent_id)
            ->setAll_children($all_children)
            ->setChildren($children)
            ->setCreated_at($created_at)
            ->setUpdated_at($updated_at)
            ->setName($name)
            ->setUrl_key($url_key)
            ->setDescription($description)
            ->setMeta_title($meta_title)
            ->setMeta_keywords($meta_keywords)
            ->setMeta_description($meta_description)
            ->setPath($path)
            ->setUrl_path($url_path)
            ->setChildren_count($children_count)
            ->setDisplay_mode($display_mode)
            ->setIs_anchor($is_anchor)
            ->setAvailable_sort_by($available_sort_by)
            ->setCustom_design($custom_design)
            ->setCustom_design_apply($custom_design_apply)
            ->setCustom_design_from($custom_design_from)
            ->setCustom_design_to($custom_design_to)
            ->setPage_layout($page_layout)
            ->setCustom_layout_update($custom_layout_update)
            ->setDefault_sort_by($default_sort_by)
            ->setLanding_page($landing_page)
            ->setInclude_in_menu($include_in_menu)
            ->setCustom_use_parent_settings($custom_use_parent_settings)
            ->setCustom_apply_to_products($custom_apply_to_products)
            ->setFilter_price_range($filter_price_range);
    }
    /**
     * Get category_id value
     * @return string|null
     */
    public function getCategory_id()
    {
        return $this->category_id;
    }
    /**
     * Set category_id value
     * @param string $category_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setCategory_id($category_id = null)
    {
        // validation for constraint: string
        if (!is_null($category_id) && !is_string($category_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($category_id)), __LINE__);
        }
        $this->category_id = $category_id;
        return $this;
    }
    /**
     * Get is_active value
     * @return int|null
     */
    public function getIs_active()
    {
        return $this->is_active;
    }
    /**
     * Set is_active value
     * @param int $is_active
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setIs_active($is_active = null)
    {
        // validation for constraint: int
        if (!is_null($is_active) && !is_numeric($is_active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_active)), __LINE__);
        }
        $this->is_active = $is_active;
        return $this;
    }
    /**
     * Get position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param string $position
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($position)), __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Get level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->level;
    }
    /**
     * Set level value
     * @param string $level
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setLevel($level = null)
    {
        // validation for constraint: string
        if (!is_null($level) && !is_string($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($level)), __LINE__);
        }
        $this->level = $level;
        return $this;
    }
    /**
     * Get parent_id value
     * @return string|null
     */
    public function getParent_id()
    {
        return $this->parent_id;
    }
    /**
     * Set parent_id value
     * @param string $parent_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setParent_id($parent_id = null)
    {
        // validation for constraint: string
        if (!is_null($parent_id) && !is_string($parent_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parent_id)), __LINE__);
        }
        $this->parent_id = $parent_id;
        return $this;
    }
    /**
     * Get all_children value
     * @return string|null
     */
    public function getAll_children()
    {
        return $this->all_children;
    }
    /**
     * Set all_children value
     * @param string $all_children
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setAll_children($all_children = null)
    {
        // validation for constraint: string
        if (!is_null($all_children) && !is_string($all_children)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($all_children)), __LINE__);
        }
        $this->all_children = $all_children;
        return $this;
    }
    /**
     * Get children value
     * @return string|null
     */
    public function getChildren()
    {
        return $this->children;
    }
    /**
     * Set children value
     * @param string $children
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setChildren($children = null)
    {
        // validation for constraint: string
        if (!is_null($children) && !is_string($children)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($children)), __LINE__);
        }
        $this->children = $children;
        return $this;
    }
    /**
     * Get created_at value
     * @return string|null
     */
    public function getCreated_at()
    {
        return $this->created_at;
    }
    /**
     * Set created_at value
     * @param string $created_at
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setCreated_at($created_at = null)
    {
        // validation for constraint: string
        if (!is_null($created_at) && !is_string($created_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created_at)), __LINE__);
        }
        $this->created_at = $created_at;
        return $this;
    }
    /**
     * Get updated_at value
     * @return string|null
     */
    public function getUpdated_at()
    {
        return $this->updated_at;
    }
    /**
     * Set updated_at value
     * @param string $updated_at
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setUpdated_at($updated_at = null)
    {
        // validation for constraint: string
        if (!is_null($updated_at) && !is_string($updated_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updated_at)), __LINE__);
        }
        $this->updated_at = $updated_at;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get url_key value
     * @return string|null
     */
    public function getUrl_key()
    {
        return $this->url_key;
    }
    /**
     * Set url_key value
     * @param string $url_key
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setUrl_key($url_key = null)
    {
        // validation for constraint: string
        if (!is_null($url_key) && !is_string($url_key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url_key)), __LINE__);
        }
        $this->url_key = $url_key;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get meta_title value
     * @return string|null
     */
    public function getMeta_title()
    {
        return $this->meta_title;
    }
    /**
     * Set meta_title value
     * @param string $meta_title
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setMeta_title($meta_title = null)
    {
        // validation for constraint: string
        if (!is_null($meta_title) && !is_string($meta_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meta_title)), __LINE__);
        }
        $this->meta_title = $meta_title;
        return $this;
    }
    /**
     * Get meta_keywords value
     * @return string|null
     */
    public function getMeta_keywords()
    {
        return $this->meta_keywords;
    }
    /**
     * Set meta_keywords value
     * @param string $meta_keywords
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setMeta_keywords($meta_keywords = null)
    {
        // validation for constraint: string
        if (!is_null($meta_keywords) && !is_string($meta_keywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meta_keywords)), __LINE__);
        }
        $this->meta_keywords = $meta_keywords;
        return $this;
    }
    /**
     * Get meta_description value
     * @return string|null
     */
    public function getMeta_description()
    {
        return $this->meta_description;
    }
    /**
     * Set meta_description value
     * @param string $meta_description
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setMeta_description($meta_description = null)
    {
        // validation for constraint: string
        if (!is_null($meta_description) && !is_string($meta_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meta_description)), __LINE__);
        }
        $this->meta_description = $meta_description;
        return $this;
    }
    /**
     * Get path value
     * @return string|null
     */
    public function getPath()
    {
        return $this->path;
    }
    /**
     * Set path value
     * @param string $path
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setPath($path = null)
    {
        // validation for constraint: string
        if (!is_null($path) && !is_string($path)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($path)), __LINE__);
        }
        $this->path = $path;
        return $this;
    }
    /**
     * Get url_path value
     * @return string|null
     */
    public function getUrl_path()
    {
        return $this->url_path;
    }
    /**
     * Set url_path value
     * @param string $url_path
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setUrl_path($url_path = null)
    {
        // validation for constraint: string
        if (!is_null($url_path) && !is_string($url_path)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url_path)), __LINE__);
        }
        $this->url_path = $url_path;
        return $this;
    }
    /**
     * Get children_count value
     * @return int|null
     */
    public function getChildren_count()
    {
        return $this->children_count;
    }
    /**
     * Set children_count value
     * @param int $children_count
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setChildren_count($children_count = null)
    {
        // validation for constraint: int
        if (!is_null($children_count) && !is_numeric($children_count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($children_count)), __LINE__);
        }
        $this->children_count = $children_count;
        return $this;
    }
    /**
     * Get display_mode value
     * @return string|null
     */
    public function getDisplay_mode()
    {
        return $this->display_mode;
    }
    /**
     * Set display_mode value
     * @param string $display_mode
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setDisplay_mode($display_mode = null)
    {
        // validation for constraint: string
        if (!is_null($display_mode) && !is_string($display_mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($display_mode)), __LINE__);
        }
        $this->display_mode = $display_mode;
        return $this;
    }
    /**
     * Get is_anchor value
     * @return int|null
     */
    public function getIs_anchor()
    {
        return $this->is_anchor;
    }
    /**
     * Set is_anchor value
     * @param int $is_anchor
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setIs_anchor($is_anchor = null)
    {
        // validation for constraint: int
        if (!is_null($is_anchor) && !is_numeric($is_anchor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_anchor)), __LINE__);
        }
        $this->is_anchor = $is_anchor;
        return $this;
    }
    /**
     * Get available_sort_by value
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfString|null
     */
    public function getAvailable_sort_by()
    {
        return $this->available_sort_by;
    }
    /**
     * Set available_sort_by value
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $available_sort_by
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setAvailable_sort_by(\App\Api\Client\Magento\Type\ArrayType\ArrayOfString $available_sort_by = null)
    {
        $this->available_sort_by = $available_sort_by;
        return $this;
    }
    /**
     * Get custom_design value
     * @return string|null
     */
    public function getCustom_design()
    {
        return $this->custom_design;
    }
    /**
     * Set custom_design value
     * @param string $custom_design
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setCustom_design($custom_design = null)
    {
        // validation for constraint: string
        if (!is_null($custom_design) && !is_string($custom_design)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_design)), __LINE__);
        }
        $this->custom_design = $custom_design;
        return $this;
    }
    /**
     * Get custom_design_apply value
     * @return string|null
     */
    public function getCustom_design_apply()
    {
        return $this->custom_design_apply;
    }
    /**
     * Set custom_design_apply value
     * @param string $custom_design_apply
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setCustom_design_apply($custom_design_apply = null)
    {
        // validation for constraint: string
        if (!is_null($custom_design_apply) && !is_string($custom_design_apply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_design_apply)), __LINE__);
        }
        $this->custom_design_apply = $custom_design_apply;
        return $this;
    }
    /**
     * Get custom_design_from value
     * @return string|null
     */
    public function getCustom_design_from()
    {
        return $this->custom_design_from;
    }
    /**
     * Set custom_design_from value
     * @param string $custom_design_from
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setCustom_design_from($custom_design_from = null)
    {
        // validation for constraint: string
        if (!is_null($custom_design_from) && !is_string($custom_design_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_design_from)), __LINE__);
        }
        $this->custom_design_from = $custom_design_from;
        return $this;
    }
    /**
     * Get custom_design_to value
     * @return string|null
     */
    public function getCustom_design_to()
    {
        return $this->custom_design_to;
    }
    /**
     * Set custom_design_to value
     * @param string $custom_design_to
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setCustom_design_to($custom_design_to = null)
    {
        // validation for constraint: string
        if (!is_null($custom_design_to) && !is_string($custom_design_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_design_to)), __LINE__);
        }
        $this->custom_design_to = $custom_design_to;
        return $this;
    }
    /**
     * Get page_layout value
     * @return string|null
     */
    public function getPage_layout()
    {
        return $this->page_layout;
    }
    /**
     * Set page_layout value
     * @param string $page_layout
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setPage_layout($page_layout = null)
    {
        // validation for constraint: string
        if (!is_null($page_layout) && !is_string($page_layout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($page_layout)), __LINE__);
        }
        $this->page_layout = $page_layout;
        return $this;
    }
    /**
     * Get custom_layout_update value
     * @return string|null
     */
    public function getCustom_layout_update()
    {
        return $this->custom_layout_update;
    }
    /**
     * Set custom_layout_update value
     * @param string $custom_layout_update
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setCustom_layout_update($custom_layout_update = null)
    {
        // validation for constraint: string
        if (!is_null($custom_layout_update) && !is_string($custom_layout_update)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_layout_update)), __LINE__);
        }
        $this->custom_layout_update = $custom_layout_update;
        return $this;
    }
    /**
     * Get default_sort_by value
     * @return string|null
     */
    public function getDefault_sort_by()
    {
        return $this->default_sort_by;
    }
    /**
     * Set default_sort_by value
     * @param string $default_sort_by
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setDefault_sort_by($default_sort_by = null)
    {
        // validation for constraint: string
        if (!is_null($default_sort_by) && !is_string($default_sort_by)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($default_sort_by)), __LINE__);
        }
        $this->default_sort_by = $default_sort_by;
        return $this;
    }
    /**
     * Get landing_page value
     * @return int|null
     */
    public function getLanding_page()
    {
        return $this->landing_page;
    }
    /**
     * Set landing_page value
     * @param int $landing_page
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setLanding_page($landing_page = null)
    {
        // validation for constraint: int
        if (!is_null($landing_page) && !is_numeric($landing_page)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($landing_page)), __LINE__);
        }
        $this->landing_page = $landing_page;
        return $this;
    }
    /**
     * Get include_in_menu value
     * @return int|null
     */
    public function getInclude_in_menu()
    {
        return $this->include_in_menu;
    }
    /**
     * Set include_in_menu value
     * @param int $include_in_menu
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setInclude_in_menu($include_in_menu = null)
    {
        // validation for constraint: int
        if (!is_null($include_in_menu) && !is_numeric($include_in_menu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($include_in_menu)), __LINE__);
        }
        $this->include_in_menu = $include_in_menu;
        return $this;
    }
    /**
     * Get custom_use_parent_settings value
     * @return int|null
     */
    public function getCustom_use_parent_settings()
    {
        return $this->custom_use_parent_settings;
    }
    /**
     * Set custom_use_parent_settings value
     * @param int $custom_use_parent_settings
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setCustom_use_parent_settings($custom_use_parent_settings = null)
    {
        // validation for constraint: int
        if (!is_null($custom_use_parent_settings) && !is_numeric($custom_use_parent_settings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($custom_use_parent_settings)), __LINE__);
        }
        $this->custom_use_parent_settings = $custom_use_parent_settings;
        return $this;
    }
    /**
     * Get custom_apply_to_products value
     * @return int|null
     */
    public function getCustom_apply_to_products()
    {
        return $this->custom_apply_to_products;
    }
    /**
     * Set custom_apply_to_products value
     * @param int $custom_apply_to_products
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setCustom_apply_to_products($custom_apply_to_products = null)
    {
        // validation for constraint: int
        if (!is_null($custom_apply_to_products) && !is_numeric($custom_apply_to_products)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($custom_apply_to_products)), __LINE__);
        }
        $this->custom_apply_to_products = $custom_apply_to_products;
        return $this;
    }
    /**
     * Get filter_price_range value
     * @return string|null
     */
    public function getFilter_price_range()
    {
        return $this->filter_price_range;
    }
    /**
     * Set filter_price_range value
     * @param string $filter_price_range
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public function setFilter_price_range($filter_price_range = null)
    {
        // validation for constraint: string
        if (!is_null($filter_price_range) && !is_string($filter_price_range)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filter_price_range)), __LINE__);
        }
        $this->filter_price_range = $filter_price_range;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
