<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogCategoryEntity StructType
 * @subpackage Structs
 */
class CatalogCategoryEntity extends AbstractStructBase
{
    /**
     * The category_id
     * @var int
     */
    public $category_id;
    /**
     * The parent_id
     * @var int
     */
    public $parent_id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The is_active
     * @var int
     */
    public $is_active;
    /**
     * The position
     * @var int
     */
    public $position;
    /**
     * The level
     * @var int
     */
    public $level;
    /**
     * The children
     * @var \App\Api\Client\Magento\Type\ArrayType\ArrayOfCatalogCategoryEntities
     */
    public $children;
    /**
     * Constructor method for catalogCategoryEntity
     * @uses CatalogCategoryEntity::setCategory_id()
     * @uses CatalogCategoryEntity::setParent_id()
     * @uses CatalogCategoryEntity::setName()
     * @uses CatalogCategoryEntity::setIs_active()
     * @uses CatalogCategoryEntity::setPosition()
     * @uses CatalogCategoryEntity::setLevel()
     * @uses CatalogCategoryEntity::setChildren()
     * @param int $category_id
     * @param int $parent_id
     * @param string $name
     * @param int $is_active
     * @param int $position
     * @param int $level
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfCatalogCategoryEntities $children
     */
    public function __construct($category_id = null, $parent_id = null, $name = null, $is_active = null, $position = null, $level = null, \App\Api\Client\Magento\Type\ArrayType\ArrayOfCatalogCategoryEntities $children = null)
    {
        $this
            ->setCategory_id($category_id)
            ->setParent_id($parent_id)
            ->setName($name)
            ->setIs_active($is_active)
            ->setPosition($position)
            ->setLevel($level)
            ->setChildren($children);
    }
    /**
     * Get category_id value
     * @return int|null
     */
    public function getCategory_id()
    {
        return $this->category_id;
    }
    /**
     * Set category_id value
     * @param int $category_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryEntity
     */
    public function setCategory_id($category_id = null)
    {
        // validation for constraint: int
        if (!is_null($category_id) && !is_numeric($category_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($category_id)), __LINE__);
        }
        $this->category_id = $category_id;
        return $this;
    }
    /**
     * Get parent_id value
     * @return int|null
     */
    public function getParent_id()
    {
        return $this->parent_id;
    }
    /**
     * Set parent_id value
     * @param int $parent_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryEntity
     */
    public function setParent_id($parent_id = null)
    {
        // validation for constraint: int
        if (!is_null($parent_id) && !is_numeric($parent_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parent_id)), __LINE__);
        }
        $this->parent_id = $parent_id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get is_active value
     * @return int|null
     */
    public function getIs_active()
    {
        return $this->is_active;
    }
    /**
     * Set is_active value
     * @param int $is_active
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryEntity
     */
    public function setIs_active($is_active = null)
    {
        // validation for constraint: int
        if (!is_null($is_active) && !is_numeric($is_active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_active)), __LINE__);
        }
        $this->is_active = $is_active;
        return $this;
    }
    /**
     * Get position value
     * @return int|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param int $position
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryEntity
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !is_numeric($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($position)), __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Get level value
     * @return int|null
     */
    public function getLevel()
    {
        return $this->level;
    }
    /**
     * Set level value
     * @param int $level
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryEntity
     */
    public function setLevel($level = null)
    {
        // validation for constraint: int
        if (!is_null($level) && !is_numeric($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($level)), __LINE__);
        }
        $this->level = $level;
        return $this;
    }
    /**
     * Get children value
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfCatalogCategoryEntities|null
     */
    public function getChildren()
    {
        return $this->children;
    }
    /**
     * Set children value
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfCatalogCategoryEntities $children
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryEntity
     */
    public function setChildren(\App\Api\Client\Magento\Type\ArrayType\ArrayOfCatalogCategoryEntities $children = null)
    {
        $this->children = $children;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
