<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogCategoryAttributeOptionsRequestParam StructType
 * @subpackage Structs
 */
class CatalogCategoryAttributeOptionsRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The attributeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $attributeId;
    /**
     * The store
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $store;
    /**
     * Constructor method for catalogCategoryAttributeOptionsRequestParam
     * @uses CatalogCategoryAttributeOptionsRequestParam::setSessionId()
     * @uses CatalogCategoryAttributeOptionsRequestParam::setAttributeId()
     * @uses CatalogCategoryAttributeOptionsRequestParam::setStore()
     * @param string $sessionId
     * @param string $attributeId
     * @param string $store
     */
    public function __construct($sessionId = null, $attributeId = null, $store = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setAttributeId($attributeId)
            ->setStore($store);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeOptionsRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get attributeId value
     * @return string
     */
    public function getAttributeId()
    {
        return $this->attributeId;
    }
    /**
     * Set attributeId value
     * @param string $attributeId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeOptionsRequestParam
     */
    public function setAttributeId($attributeId = null)
    {
        // validation for constraint: string
        if (!is_null($attributeId) && !is_string($attributeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributeId)), __LINE__);
        }
        $this->attributeId = $attributeId;
        return $this;
    }
    /**
     * Get store value
     * @return string|null
     */
    public function getStore()
    {
        return $this->store;
    }
    /**
     * Set store value
     * @param string $store
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeOptionsRequestParam
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        $this->store = $store;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeOptionsRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
