<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogAttributeEntity StructType
 * @subpackage Structs
 */
class CatalogAttributeEntity extends AbstractStructBase
{
    /**
     * The attribute_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $attribute_id;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The required
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $required;
    /**
     * The scope
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $scope;
    /**
     * Constructor method for catalogAttributeEntity
     * @uses CatalogAttributeEntity::setAttribute_id()
     * @uses CatalogAttributeEntity::setCode()
     * @uses CatalogAttributeEntity::setType()
     * @uses CatalogAttributeEntity::setRequired()
     * @uses CatalogAttributeEntity::setScope()
     * @param int $attribute_id
     * @param string $code
     * @param string $type
     * @param string $required
     * @param string $scope
     */
    public function __construct($attribute_id = null, $code = null, $type = null, $required = null, $scope = null)
    {
        $this
            ->setAttribute_id($attribute_id)
            ->setCode($code)
            ->setType($type)
            ->setRequired($required)
            ->setScope($scope);
    }
    /**
     * Get attribute_id value
     * @return int|null
     */
    public function getAttribute_id()
    {
        return $this->attribute_id;
    }
    /**
     * Set attribute_id value
     * @param int $attribute_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAttributeEntity
     */
    public function setAttribute_id($attribute_id = null)
    {
        // validation for constraint: int
        if (!is_null($attribute_id) && !is_numeric($attribute_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($attribute_id)), __LINE__);
        }
        $this->attribute_id = $attribute_id;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAttributeEntity
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAttributeEntity
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get required value
     * @return string|null
     */
    public function getRequired()
    {
        return $this->required;
    }
    /**
     * Set required value
     * @param string $required
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAttributeEntity
     */
    public function setRequired($required = null)
    {
        // validation for constraint: string
        if (!is_null($required) && !is_string($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($required)), __LINE__);
        }
        $this->required = $required;
        return $this;
    }
    /**
     * Get scope value
     * @return string|null
     */
    public function getScope()
    {
        return $this->scope;
    }
    /**
     * Set scope value
     * @param string $scope
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAttributeEntity
     */
    public function setScope($scope = null)
    {
        // validation for constraint: string
        if (!is_null($scope) && !is_string($scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scope)), __LINE__);
        }
        $this->scope = $scope;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAttributeEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
