<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for callParam StructType
 * @subpackage Structs
 */
class CallParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The apiPath
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $apiPath;
    /**
     * The args
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var mixed
     */
    public $args;
    /**
     * Constructor method for callParam
     * @uses CallParam::setSessionId()
     * @uses CallParam::setApiPath()
     * @uses CallParam::setArgs()
     * @param string $sessionId
     * @param string $apiPath
     * @param mixed $args
     */
    public function __construct($sessionId = null, $apiPath = null, $args = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setApiPath($apiPath)
            ->setArgs($args);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CallParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get apiPath value
     * @return string
     */
    public function getApiPath()
    {
        return $this->apiPath;
    }
    /**
     * Set apiPath value
     * @param string $apiPath
     * @return \App\Api\Client\Magento\Type\StructType\CallParam
     */
    public function setApiPath($apiPath = null)
    {
        // validation for constraint: string
        if (!is_null($apiPath) && !is_string($apiPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiPath)), __LINE__);
        }
        $this->apiPath = $apiPath;
        return $this;
    }
    /**
     * Get args value
     * @return mixed
     */
    public function getArgs()
    {
        return $this->args;
    }
    /**
     * Set args value
     * @param mixed $args
     * @return \App\Api\Client\Magento\Type\StructType\CallParam
     */
    public function setArgs($args = null)
    {
        $this->args = $args;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CallParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
