<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for apiMethodEntity StructType
 * @subpackage Structs
 */
class ApiMethodEntity extends AbstractStructBase
{
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The path
     * @var string
     */
    public $path;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The aliases
     * @var \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public $aliases;
    /**
     * Constructor method for apiMethodEntity
     * @uses ApiMethodEntity::setTitle()
     * @uses ApiMethodEntity::setPath()
     * @uses ApiMethodEntity::setName()
     * @uses ApiMethodEntity::setAliases()
     * @param string $title
     * @param string $path
     * @param string $name
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $aliases
     */
    public function __construct($title = null, $path = null, $name = null, \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $aliases = null)
    {
        $this
            ->setTitle($title)
            ->setPath($path)
            ->setName($name)
            ->setAliases($aliases);
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \App\Api\Client\Magento\Type\StructType\ApiMethodEntity
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get path value
     * @return string|null
     */
    public function getPath()
    {
        return $this->path;
    }
    /**
     * Set path value
     * @param string $path
     * @return \App\Api\Client\Magento\Type\StructType\ApiMethodEntity
     */
    public function setPath($path = null)
    {
        // validation for constraint: string
        if (!is_null($path) && !is_string($path)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($path)), __LINE__);
        }
        $this->path = $path;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Api\Client\Magento\Type\StructType\ApiMethodEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get aliases value
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfString|null
     */
    public function getAliases()
    {
        return $this->aliases;
    }
    /**
     * Set aliases value
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $aliases
     * @return \App\Api\Client\Magento\Type\StructType\ApiMethodEntity
     */
    public function setAliases(\App\Api\Client\Magento\Type\ArrayType\ArrayOfString $aliases = null)
    {
        $this->aliases = $aliases;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ApiMethodEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
