<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for apiEntity StructType
 * @subpackage Structs
 */
class ApiEntity extends AbstractStructBase
{
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The aliases
     * @var \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public $aliases;
    /**
     * The methods
     * @var \App\Api\Client\Magento\Type\ArrayType\ArrayOfApiMethods
     */
    public $methods;
    /**
     * Constructor method for apiEntity
     * @uses ApiEntity::setTitle()
     * @uses ApiEntity::setName()
     * @uses ApiEntity::setAliases()
     * @uses ApiEntity::setMethods()
     * @param string $title
     * @param string $name
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $aliases
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfApiMethods $methods
     */
    public function __construct($title = null, $name = null, \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $aliases = null, \App\Api\Client\Magento\Type\ArrayType\ArrayOfApiMethods $methods = null)
    {
        $this
            ->setTitle($title)
            ->setName($name)
            ->setAliases($aliases)
            ->setMethods($methods);
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \App\Api\Client\Magento\Type\StructType\ApiEntity
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Api\Client\Magento\Type\StructType\ApiEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get aliases value
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfString|null
     */
    public function getAliases()
    {
        return $this->aliases;
    }
    /**
     * Set aliases value
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $aliases
     * @return \App\Api\Client\Magento\Type\StructType\ApiEntity
     */
    public function setAliases(\App\Api\Client\Magento\Type\ArrayType\ArrayOfString $aliases = null)
    {
        $this->aliases = $aliases;
        return $this;
    }
    /**
     * Get methods value
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfApiMethods|null
     */
    public function getMethods()
    {
        return $this->methods;
    }
    /**
     * Set methods value
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfApiMethods $methods
     * @return \App\Api\Client\Magento\Type\StructType\ApiEntity
     */
    public function setMethods(\App\Api\Client\Magento\Type\ArrayType\ArrayOfApiMethods $methods = null)
    {
        $this->methods = $methods;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ApiEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
