<?php

namespace App\Api\Client\Magento\Type\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Resource ServiceType
 * @subpackage Services
 */
class Resource extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named resourceFaults
     * Meta informations extracted from the WSDL
     * - documentation: List of resource faults
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ResourceFaultsParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ResourceFaultsResponseParam|bool
     */
    public function resourceFaults(\App\Api\Client\Magento\Type\StructType\ResourceFaultsParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->resourceFaults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Api\Client\Magento\Type\StructType\ResourceFaultsResponseParam
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
