<?php

namespace App\Api\Client\Magento\Type\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for End ServiceType
 * @subpackage Services
 */
class End extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named endSession
     * Meta informations extracted from the WSDL
     * - documentation: End web service session
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\EndSessionParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\EndSessionResponseParam|bool
     */
    public function endSession(\App\Api\Client\Magento\Type\StructType\EndSessionParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->endSession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Api\Client\Magento\Type\StructType\EndSessionResponseParam
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
