<?php

namespace App\Api\Client\Magento\Type\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Directory ServiceType
 * @subpackage Services
 */
class Directory extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named directoryCountryList
     * Meta informations extracted from the WSDL
     * - documentation: List of countries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\DirectoryCountryListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\DirectoryCountryListResponseParam|bool
     */
    public function directoryCountryList(\App\Api\Client\Magento\Type\StructType\DirectoryCountryListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->directoryCountryList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named directoryRegionList
     * Meta informations extracted from the WSDL
     * - documentation: List of regions in specified country
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\DirectoryRegionListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\DirectoryRegionListResponseParam|bool
     */
    public function directoryRegionList(\App\Api\Client\Magento\Type\StructType\DirectoryRegionListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->directoryRegionList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Api\Client\Magento\Type\StructType\DirectoryCountryListResponseParam|\App\Api\Client\Magento\Type\StructType\DirectoryRegionListResponseParam
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
