<?php

namespace App\Api\Client\Magento\Type\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Catalog ServiceType
 * @subpackage Services
 */
class Catalog extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named catalogCategoryCurrentStore
     * Meta informations extracted from the WSDL
     * - documentation: Set_Get current store view
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryCurrentStoreRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryCurrentStoreResponseParam|bool
     */
    public function catalogCategoryCurrentStore(\App\Api\Client\Magento\Type\StructType\CatalogCategoryCurrentStoreRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryCurrentStore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogCategoryTree
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve hierarchical tree of categories.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryTreeRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryTreeResponseParam|bool
     */
    public function catalogCategoryTree(\App\Api\Client\Magento\Type\StructType\CatalogCategoryTreeRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryTree($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogCategoryLevel
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve hierarchical tree of categories.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryLevelRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryLevelResponseParam|bool
     */
    public function catalogCategoryLevel(\App\Api\Client\Magento\Type\StructType\CatalogCategoryLevelRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryLevel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogCategoryInfo
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve hierarchical tree of categories.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryInfoResponseParam|bool
     */
    public function catalogCategoryInfo(\App\Api\Client\Magento\Type\StructType\CatalogCategoryInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogCategoryCreate
     * Meta informations extracted from the WSDL
     * - documentation: Create new category and return its id.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryCreateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryCreateResponseParam|bool
     */
    public function catalogCategoryCreate(\App\Api\Client\Magento\Type\StructType\CatalogCategoryCreateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogCategoryUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Update category
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateResponseParam|bool
     */
    public function catalogCategoryUpdate(\App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogCategoryMove
     * Meta informations extracted from the WSDL
     * - documentation: Move category in tree
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryMoveRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryMoveResponseParam|bool
     */
    public function catalogCategoryMove(\App\Api\Client\Magento\Type\StructType\CatalogCategoryMoveRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryMove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogCategoryDelete
     * Meta informations extracted from the WSDL
     * - documentation: Delete category
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryDeleteRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryDeleteResponseParam|bool
     */
    public function catalogCategoryDelete(\App\Api\Client\Magento\Type\StructType\CatalogCategoryDeleteRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryDelete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogCategoryAssignedProducts
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve list of assigned products
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryAssignedProductsRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryAssignedProductsResponseParam|bool
     */
    public function catalogCategoryAssignedProducts(\App\Api\Client\Magento\Type\StructType\CatalogCategoryAssignedProductsRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryAssignedProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogCategoryAssignProduct
     * Meta informations extracted from the WSDL
     * - documentation: Assign product to category
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryAssignProductRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryAssignProductResponseParam|bool
     */
    public function catalogCategoryAssignProduct(\App\Api\Client\Magento\Type\StructType\CatalogCategoryAssignProductRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryAssignProduct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogCategoryUpdateProduct
     * Meta informations extracted from the WSDL
     * - documentation: Update assigned product
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateProductRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateProductResponseParam|bool
     */
    public function catalogCategoryUpdateProduct(\App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateProductRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryUpdateProduct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogCategoryRemoveProduct
     * Meta informations extracted from the WSDL
     * - documentation: Remove product assignment from category
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryRemoveProductRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryRemoveProductResponseParam|bool
     */
    public function catalogCategoryRemoveProduct(\App\Api\Client\Magento\Type\StructType\CatalogCategoryRemoveProductRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryRemoveProduct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductCurrentStore
     * Meta informations extracted from the WSDL
     * - documentation: Set/Get current store view
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCurrentStoreRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCurrentStoreResponseParam|bool
     */
    public function catalogProductCurrentStore(\App\Api\Client\Magento\Type\StructType\CatalogProductCurrentStoreRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductCurrentStore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve products list by filters
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductListResponseParam|bool
     */
    public function catalogProductList(\App\Api\Client\Magento\Type\StructType\CatalogProductListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductInfo
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve product
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductInfoResponseParam|bool
     */
    public function catalogProductInfo(\App\Api\Client\Magento\Type\StructType\CatalogProductInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductCreate
     * Meta informations extracted from the WSDL
     * - documentation: Create new product and return product id
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCreateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCreateResponseParam|bool
     */
    public function catalogProductCreate(\App\Api\Client\Magento\Type\StructType\CatalogProductCreateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Update product
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductUpdateResponseParam|bool
     */
    public function catalogProductUpdate(\App\Api\Client\Magento\Type\StructType\CatalogProductUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductMultiUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Product multi update
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductMultiUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductMultiUpdateResponseParam|bool
     */
    public function catalogProductMultiUpdate(\App\Api\Client\Magento\Type\StructType\CatalogProductMultiUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductMultiUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductSetSpecialPrice
     * Meta informations extracted from the WSDL
     * - documentation: Update product special price
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductSetSpecialPriceRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductSetSpecialPriceResponseParam|bool
     */
    public function catalogProductSetSpecialPrice(\App\Api\Client\Magento\Type\StructType\CatalogProductSetSpecialPriceRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductSetSpecialPrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductGetSpecialPrice
     * Meta informations extracted from the WSDL
     * - documentation: Get product special price data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductGetSpecialPriceRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductGetSpecialPriceResponseParam|bool
     */
    public function catalogProductGetSpecialPrice(\App\Api\Client\Magento\Type\StructType\CatalogProductGetSpecialPriceRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductGetSpecialPrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductDelete
     * Meta informations extracted from the WSDL
     * - documentation: Delete product
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductDeleteRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDeleteResponseParam|bool
     */
    public function catalogProductDelete(\App\Api\Client\Magento\Type\StructType\CatalogProductDeleteRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductDelete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogProductAttributeCurrentStore
     * Meta informations extracted from the WSDL
     * - documentation: Set/Get current store view
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeCurrentStoreRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeCurrentStoreResponseParam|bool
     */
    public function catalogProductAttributeCurrentStore(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeCurrentStoreRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeCurrentStore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve attribute list
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeListResponseParam|bool
     */
    public function catalogProductAttributeList(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeOptions
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve attribute options
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeOptionsRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeOptionsResponseParam|bool
     */
    public function catalogProductAttributeOptions(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeOptionsRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeOptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductCustomOptionAdd
     * Meta informations extracted from the WSDL
     * - documentation: Add new custom option into product
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionAddRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionAddResponseParam|bool
     */
    public function catalogProductCustomOptionAdd(\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionAddRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductCustomOptionAdd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductCustomOptionUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Update product custom option
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionUpdateResponseParam|bool
     */
    public function catalogProductCustomOptionUpdate(\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductCustomOptionUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductCustomOptionTypes
     * Meta informations extracted from the WSDL
     * - documentation: Get list of available custom option types
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionTypesRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionTypesResponseParam|bool
     */
    public function catalogProductCustomOptionTypes(\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionTypesRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductCustomOptionTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductCustomOptionList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve list of product custom options
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionListResponseParam|bool
     */
    public function catalogProductCustomOptionList(\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductCustomOptionList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductCustomOptionInfo
     * Meta informations extracted from the WSDL
     * - documentation: Get full information about custom option in product
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionInfoResponseParam|bool
     */
    public function catalogProductCustomOptionInfo(\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductCustomOptionInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductCustomOptionRemove
     * Meta informations extracted from the WSDL
     * - documentation: Remove custom option
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionRemoveRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionRemoveResponseParam|bool
     */
    public function catalogProductCustomOptionRemove(\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionRemoveRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductCustomOptionRemove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogProductCustomOptionValueList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve custom option values list
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueListResponseParam|bool
     */
    public function catalogProductCustomOptionValueList(\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductCustomOptionValueList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogProductCustomOptionValueInfo
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve custom option value info
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueInfoResponseParam|bool
     */
    public function catalogProductCustomOptionValueInfo(\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductCustomOptionValueInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductCustomOptionValueAdd
     * Meta informations extracted from the WSDL
     * - documentation: Add new custom option values
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueAddRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueAddResponseParam|bool
     */
    public function catalogProductCustomOptionValueAdd(\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueAddRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductCustomOptionValueAdd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogProductCustomOptionValueUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Update custom option value
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueUpdateResponseParam|bool
     */
    public function catalogProductCustomOptionValueUpdate(\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductCustomOptionValueUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogProductCustomOptionValueRemove
     * Meta informations extracted from the WSDL
     * - documentation: Remove value from custom option
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueRemoveRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueRemoveResponseParam|bool
     */
    public function catalogProductCustomOptionValueRemove(\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueRemoveRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductCustomOptionValueRemove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeSetCreate
     * Meta informations extracted from the WSDL
     * - documentation: Create product attribute set based on another set
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetCreateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetCreateResponseParam|bool
     */
    public function catalogProductAttributeSetCreate(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetCreateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeSetCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeSetRemove
     * Meta informations extracted from the WSDL
     * - documentation: Remove product attribute set
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetRemoveRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetRemoveResponseParam|bool
     */
    public function catalogProductAttributeSetRemove(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetRemoveRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeSetRemove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeSetList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve product attribute sets
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetListResponseParam|bool
     */
    public function catalogProductAttributeSetList(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeSetList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogProductAttributeSetAttributeAdd
     * Meta informations extracted from the WSDL
     * - documentation: Add attribute into attribute set
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeAddRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeAddResponseParam|bool
     */
    public function catalogProductAttributeSetAttributeAdd(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeAddRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeSetAttributeAdd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogProductAttributeSetAttributeRemove
     * Meta informations extracted from the WSDL
     * - documentation: Remove attribute from attribute set
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeRemoveRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeRemoveResponseParam|bool
     */
    public function catalogProductAttributeSetAttributeRemove(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeRemoveRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeSetAttributeRemove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeAddOption
     * Meta informations extracted from the WSDL
     * - documentation: Add option to attribute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeAddOptionRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeAddOptionResponseParam|bool
     */
    public function catalogProductAttributeAddOption(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeAddOptionRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeAddOption($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeSetGroupAdd
     * Meta informations extracted from the WSDL
     * - documentation: Create group within existing attribute set
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupAddRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupAddResponseParam|bool
     */
    public function catalogProductAttributeSetGroupAdd(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupAddRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeSetGroupAdd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogProductAttributeSetGroupRename
     * Meta informations extracted from the WSDL
     * - documentation: Rename existing group
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRenameRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRenameResponseParam|bool
     */
    public function catalogProductAttributeSetGroupRename(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRenameRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeSetGroupRename($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogProductAttributeSetGroupRemove
     * Meta informations extracted from the WSDL
     * - documentation: Remove group from attribute set
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRemoveRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRemoveResponseParam|bool
     */
    public function catalogProductAttributeSetGroupRemove(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRemoveRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeSetGroupRemove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductTypeList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve product types
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductTypeListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTypeListResponseParam|bool
     */
    public function catalogProductTypeList(\App\Api\Client\Magento\Type\StructType\CatalogProductTypeListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductTypeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogProductAttributeTierPriceInfo
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve product tier prices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeTierPriceInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeTierPriceInfoResponseParam|bool
     */
    public function catalogProductAttributeTierPriceInfo(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeTierPriceInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeTierPriceInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogProductAttributeTierPriceUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Update product tier prices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeTierPriceUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeTierPriceUpdateResponseParam|bool
     */
    public function catalogProductAttributeTierPriceUpdate(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeTierPriceUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeTierPriceUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogCategoryAttributeCurrentStore
     * Meta informations extracted from the WSDL
     * - documentation: Set/Get current store view
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeCurrentStoreRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeCurrentStoreResponseParam|bool
     */
    public function catalogCategoryAttributeCurrentStore(\App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeCurrentStoreRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryAttributeCurrentStore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogCategoryAttributeList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve category attributes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeListResponseParam|bool
     */
    public function catalogCategoryAttributeList(\App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryAttributeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogCategoryAttributeOptions
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve attribute options
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeOptionsRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeOptionsResponseParam|bool
     */
    public function catalogCategoryAttributeOptions(\App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeOptionsRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogCategoryAttributeOptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogProductAttributeMediaCurrentStore
     * Meta informations extracted from the WSDL
     * - documentation: Set/Get current store view
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaCurrentStoreRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaCurrentStoreResponseParam|bool
     */
    public function catalogProductAttributeMediaCurrentStore(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaCurrentStoreRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeMediaCurrentStore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeMediaList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve product image list
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaListResponseParam|bool
     */
    public function catalogProductAttributeMediaList(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeMediaList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeMediaInfo
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve product image data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaInfoResponseParam|bool
     */
    public function catalogProductAttributeMediaInfo(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeMediaInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeMediaTypes
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve product image types
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaTypesRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaTypesResponseParam|bool
     */
    public function catalogProductAttributeMediaTypes(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaTypesRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeMediaTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeMediaCreate
     * Meta informations extracted from the WSDL
     * - documentation: Upload new product image
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaCreateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaCreateResponseParam|bool
     */
    public function catalogProductAttributeMediaCreate(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaCreateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeMediaCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeMediaUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Update product image
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaUpdateResponseParam|bool
     */
    public function catalogProductAttributeMediaUpdate(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeMediaUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeMediaRemove
     * Meta informations extracted from the WSDL
     * - documentation: Remove product image
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaRemoveRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaRemoveResponseParam|bool
     */
    public function catalogProductAttributeMediaRemove(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaRemoveRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeMediaRemove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductLinkList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve linked products
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductLinkListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkListResponseParam|bool
     */
    public function catalogProductLinkList(\App\Api\Client\Magento\Type\StructType\CatalogProductLinkListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductLinkList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductLinkAssign
     * Meta informations extracted from the WSDL
     * - documentation: Assign product link
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductLinkAssignRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkAssignResponseParam|bool
     */
    public function catalogProductLinkAssign(\App\Api\Client\Magento\Type\StructType\CatalogProductLinkAssignRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductLinkAssign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductLinkUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Update product link
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductLinkUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkUpdateResponseParam|bool
     */
    public function catalogProductLinkUpdate(\App\Api\Client\Magento\Type\StructType\CatalogProductLinkUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductLinkUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductLinkRemove
     * Meta informations extracted from the WSDL
     * - documentation: Remove product link
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductLinkRemoveRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkRemoveResponseParam|bool
     */
    public function catalogProductLinkRemove(\App\Api\Client\Magento\Type\StructType\CatalogProductLinkRemoveRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductLinkRemove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductLinkTypes
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve product link types
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductLinkTypesRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkTypesResponseParam|bool
     */
    public function catalogProductLinkTypes(\App\Api\Client\Magento\Type\StructType\CatalogProductLinkTypesRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductLinkTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductLinkAttributes
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve product link type attributes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductLinkAttributesRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkAttributesResponseParam|bool
     */
    public function catalogProductLinkAttributes(\App\Api\Client\Magento\Type\StructType\CatalogProductLinkAttributesRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductLinkAttributes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeCreate
     * Meta informations extracted from the WSDL
     * - documentation: Create new attribute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeCreateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeCreateResponseParam|bool
     */
    public function catalogProductAttributeCreate(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeCreateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeRemove
     * Meta informations extracted from the WSDL
     * - documentation: Delete attribute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeRemoveRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeRemoveResponseParam|bool
     */
    public function catalogProductAttributeRemove(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeRemoveRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeRemove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeInfo
     * Meta informations extracted from the WSDL
     * - documentation: Get full information about attribute with list of options
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeInfoResponseParam|bool
     */
    public function catalogProductAttributeInfo(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductAttributeUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Update attribute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeUpdateResponseParam|bool
     */
    public function catalogProductAttributeUpdate(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductAttributeUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogInventoryStockItemList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve stock data by product ids
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemListResponseParam|bool
     */
    public function catalogInventoryStockItemList(\App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogInventoryStockItemList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogInventoryStockItemUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Update product stock data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateResponseParam|bool
     */
    public function catalogInventoryStockItemUpdate(\App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogInventoryStockItemUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogInventoryStockItemMultiUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Multi update product stock data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemMultiUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemMultiUpdateResponseParam|bool
     */
    public function catalogInventoryStockItemMultiUpdate(\App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemMultiUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogInventoryStockItemMultiUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductTagList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve list of tags by product
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductTagListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTagListResponseParam|bool
     */
    public function catalogProductTagList(\App\Api\Client\Magento\Type\StructType\CatalogProductTagListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductTagList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductTagInfo
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve product tag info
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductTagInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTagInfoResponseParam|bool
     */
    public function catalogProductTagInfo(\App\Api\Client\Magento\Type\StructType\CatalogProductTagInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductTagInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductTagAdd
     * Meta informations extracted from the WSDL
     * - documentation: Add tag(s) to product
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductTagAddRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTagAddResponseParam|bool
     */
    public function catalogProductTagAdd(\App\Api\Client\Magento\Type\StructType\CatalogProductTagAddRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductTagAdd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductTagUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Update product tag
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductTagUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTagUpdateResponseParam|bool
     */
    public function catalogProductTagUpdate(\App\Api\Client\Magento\Type\StructType\CatalogProductTagUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductTagUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductTagRemove
     * Meta informations extracted from the WSDL
     * - documentation: Remove product tag
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductTagRemoveRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTagRemoveResponseParam|bool
     */
    public function catalogProductTagRemove(\App\Api\Client\Magento\Type\StructType\CatalogProductTagRemoveRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductTagRemove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductDownloadableLinkAdd
     * Meta informations extracted from the WSDL
     * - documentation: Add links to downloadable product
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddResponseParam|bool
     */
    public function catalogProductDownloadableLinkAdd(\App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductDownloadableLinkAdd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named catalogProductDownloadableLinkList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve list of links and samples for downloadable product
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkListResponseParam|bool
     */
    public function catalogProductDownloadableLinkList(\App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductDownloadableLinkList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * catalogProductDownloadableLinkRemove
     * Meta informations extracted from the WSDL
     * - documentation: Remove links and samples from downloadable product
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkRemoveRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkRemoveResponseParam|bool
     */
    public function catalogProductDownloadableLinkRemove(\App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkRemoveRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->catalogProductDownloadableLinkRemove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryAssignedProductsResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogCategoryAssignProductResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeCurrentStoreResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeListResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogCategoryAttributeOptionsResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogCategoryCreateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogCategoryCurrentStoreResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogCategoryDeleteResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogCategoryInfoResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogCategoryLevelResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogCategoryMoveResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogCategoryRemoveProductResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogCategoryTreeResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateProductResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemListResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemMultiUpdateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemUpdateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeAddOptionResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeCreateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeCurrentStoreResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeInfoResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeListResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaCreateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaCurrentStoreResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaInfoResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaListResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaRemoveResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaTypesResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeMediaUpdateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeOptionsResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeRemoveResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeAddResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeRemoveResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetCreateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupAddResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRemoveResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRenameResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetListResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetRemoveResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeTierPriceInfoResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeTierPriceUpdateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeUpdateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductCreateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductCurrentStoreResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionAddResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionInfoResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionListResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionRemoveResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionTypesResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionUpdateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueAddResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueInfoResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueListResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueRemoveResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductCustomOptionValueUpdateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductDeleteResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkAddResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkListResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkRemoveResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductGetSpecialPriceResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductInfoResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductLinkAssignResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductLinkAttributesResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductLinkListResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductLinkRemoveResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductLinkTypesResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductLinkUpdateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductListResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductMultiUpdateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductSetSpecialPriceResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductTagAddResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductTagInfoResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductTagListResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductTagRemoveResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductTagUpdateResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductTypeListResponseParam|\App\Api\Client\Magento\Type\StructType\CatalogProductUpdateResponseParam
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
