<?php

namespace App\Api\Client\Magento\Type;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'associativeEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\AssociativeEntity',
            'associativeArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\AssociativeArray',
            'associativeMultiEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\AssociativeMultiEntity',
            'associativeMultiArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\AssociativeMultiArray',
            'complexFilter' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ComplexFilter',
            'complexFilterArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ComplexFilterArray',
            'filters' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\Filters',
            'ArrayOfString' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ArrayOfString',
            'ArrayOfInt' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ArrayOfInt',
            'apiMethodEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ApiMethodEntity',
            'ArrayOfApiMethods' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ArrayOfApiMethods',
            'apiEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ApiEntity',
            'ArrayOfApis' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ArrayOfApis',
            'existsFaltureEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ExistsFaltureEntity',
            'ArrayOfExistsFaltures' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ArrayOfExistsFaltures',
            'callParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CallParam',
            'callResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CallResponseParam',
            'multiCallParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\MultiCallParam',
            'multiCallResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\MultiCallResponseParam',
            'endSessionParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\EndSessionParam',
            'endSessionResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\EndSessionResponseParam',
            'loginParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\LoginParam',
            'loginResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\LoginResponseParam',
            'resourcesRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ResourcesRequestParam',
            'resourcesResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ResourcesResponseParam',
            'globalFaultsParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\GlobalFaultsParam',
            'globalFaultsResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\GlobalFaultsResponseParam',
            'resourceFaultsParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ResourceFaultsParam',
            'resourceFaultsResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ResourceFaultsResponseParam',
            'startSessionResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\StartSessionResponseParam',
            'storeEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\StoreEntity',
            'storeEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\StoreEntityArray',
            'magentoInfoEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\MagentoInfoEntity',
            'storeListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\StoreListRequestParam',
            'storeListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\StoreListResponseParam',
            'storeInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\StoreInfoRequestParam',
            'storeInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\StoreInfoResponseParam',
            'magentoInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\MagentoInfoRequestParam',
            'magentoInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\MagentoInfoResponseParam',
            'directoryCountryEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\DirectoryCountryEntity',
            'directoryCountryEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\DirectoryCountryEntityArray',
            'directoryRegionEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\DirectoryRegionEntity',
            'directoryRegionEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\DirectoryRegionEntityArray',
            'directoryCountryListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\DirectoryCountryListRequestParam',
            'directoryCountryListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\DirectoryCountryListResponseParam',
            'directoryRegionListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\DirectoryRegionListRequestParam',
            'directoryRegionListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\DirectoryRegionListResponseParam',
            'customerCustomerEntityToCreate' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerCustomerEntityToCreate',
            'customerCustomerEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerCustomerEntity',
            'customerCustomerEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CustomerCustomerEntityArray',
            'customerGroupEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerGroupEntity',
            'customerGroupEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CustomerGroupEntityArray',
            'customerAddressEntityCreate' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerAddressEntityCreate',
            'customerAddressEntityItem' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerAddressEntityItem',
            'customerAddressEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CustomerAddressEntityArray',
            'customerCustomerListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerCustomerListRequestParam',
            'customerCustomerListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerCustomerListResponseParam',
            'customerCustomerCreateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerCustomerCreateRequestParam',
            'customerCustomerCreateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerCustomerCreateResponseParam',
            'customerCustomerInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerCustomerInfoRequestParam',
            'customerCustomerInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerCustomerInfoResponseParam',
            'customerCustomerUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerCustomerUpdateRequestParam',
            'customerCustomerUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerCustomerUpdateResponseParam',
            'customerCustomerDeleteRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerCustomerDeleteRequestParam',
            'customerCustomerDeleteResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerCustomerDeleteResponseParam',
            'customerGroupListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerGroupListRequestParam',
            'customerGroupListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerGroupListResponseParam',
            'customerAddressListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerAddressListRequestParam',
            'customerAddressListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerAddressListResponseParam',
            'customerAddressCreateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerAddressCreateRequestParam',
            'customerAddressCreateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerAddressCreateResponseParam',
            'customerAddressInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerAddressInfoRequestParam',
            'customerAddressInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerAddressInfoResponseParam',
            'customerAddressUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerAddressUpdateRequestParam',
            'customerAddressUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerAddressUpdateResponseParam',
            'customerAddressDeleteRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerAddressDeleteRequestParam',
            'customerAddressDeleteResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CustomerAddressDeleteResponseParam',
            'catalogProductEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductEntityArray',
            'catalogProductEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductEntity',
            'catalogProductRequestAttributes' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductRequestAttributes',
            'catalogProductReturnEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductReturnEntity',
            'catalogProductCreateEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCreateEntity',
            'catalogProductCreateEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductCreateEntityArray',
            'catalogProductAttributeSetEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetEntity',
            'catalogProductAttributeSetEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductAttributeSetEntityArray',
            'catalogProductTypeEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTypeEntity',
            'catalogProductTypeEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductTypeEntityArray',
            'catalogProductTierPriceEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTierPriceEntity',
            'catalogProductTierPriceEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductTierPriceEntityArray',
            'ArrayOfCatalogCategoryEntities' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ArrayOfCatalogCategoryEntities',
            'catalogCategoryEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryEntity',
            'catalogCategoryEntityNoChildren' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryEntityNoChildren',
            'ArrayOfCatalogCategoryEntitiesNoChildren' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ArrayOfCatalogCategoryEntitiesNoChildren',
            'catalogCategoryTree' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryTree',
            'catalogCategoryEntityCreate' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryEntityCreate',
            'catalogCategoryInfo' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryInfo',
            'catalogAssignedProduct' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogAssignedProduct',
            'catalogAssignedProductArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogAssignedProductArray',
            'catalogAttributeEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogAttributeEntity',
            'catalogAttributeEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogAttributeEntityArray',
            'catalogAttributeOptionEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogAttributeOptionEntity',
            'catalogAttributeOptionEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogAttributeOptionEntityArray',
            'catalogProductImageEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductImageEntity',
            'catalogProductImageEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductImageEntityArray',
            'catalogProductAttributeMediaTypeEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaTypeEntity',
            'catalogProductAttributeMediaTypeEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductAttributeMediaTypeEntityArray',
            'catalogProductImageFileEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductImageFileEntity',
            'catalogProductAttributeMediaCreateEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaCreateEntity',
            'catalogProductLinkEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductLinkEntity',
            'catalogProductLinkEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductLinkEntityArray',
            'catalogProductLinkAttributeEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductLinkAttributeEntity',
            'catalogProductLinkAttributeEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductLinkAttributeEntityArray',
            'catalogProductAttributeFrontendLabelEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeFrontendLabelEntity',
            'catalogProductAttributeFrontendLabelArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductAttributeFrontendLabelArray',
            'catalogProductAttributeEntityToCreate' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeEntityToCreate',
            'catalogProductCustomOptionAdditionalFieldsEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionAdditionalFieldsEntity',
            'catalogProductCustomOptionAdditionalFieldsArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductCustomOptionAdditionalFieldsArray',
            'catalogProductCustomOptionToAdd' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionToAdd',
            'catalogProductCustomOptionToUpdate' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionToUpdate',
            'catalogProductCustomOptionInfoEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionInfoEntity',
            'catalogProductCustomOptionListEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionListEntity',
            'catalogProductCustomOptionListArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductCustomOptionListArray',
            'catalogProductCustomOptionTypesEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionTypesEntity',
            'catalogProductCustomOptionTypesArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductCustomOptionTypesArray',
            'catalogProductCustomOptionValueInfoEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionValueInfoEntity',
            'catalogProductCustomOptionValueListEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionValueListEntity',
            'catalogProductCustomOptionValueListArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductCustomOptionValueListArray',
            'catalogProductCustomOptionValueAddEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionValueAddEntity',
            'catalogProductCustomOptionValueAddArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductCustomOptionValueAddArray',
            'catalogProductCustomOptionValueUpdateEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionValueUpdateEntity',
            'catalogProductAttributeOptionLabelEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeOptionLabelEntity',
            'catalogProductAttributeOptionLabelArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductAttributeOptionLabelArray',
            'catalogProductAttributeOptionEntityToAdd' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeOptionEntityToAdd',
            'catalogProductAttributeEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeEntity',
            'catalogProductAttributeEntityToUpdate' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeEntityToUpdate',
            'catalogProductSpecialPriceReturnEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductSpecialPriceReturnEntity',
            'catalogProductCurrentStoreRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCurrentStoreRequestParam',
            'catalogProductCurrentStoreResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCurrentStoreResponseParam',
            'catalogProductListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductListRequestParam',
            'catalogProductListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductListResponseParam',
            'catalogProductInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductInfoRequestParam',
            'catalogProductInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductInfoResponseParam',
            'catalogProductCreateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCreateRequestParam',
            'catalogProductCreateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCreateResponseParam',
            'catalogProductUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductUpdateRequestParam',
            'catalogProductUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductUpdateResponseParam',
            'catalogProductMultiUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductMultiUpdateRequestParam',
            'catalogProductMultiUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductMultiUpdateResponseParam',
            'catalogProductSetSpecialPriceRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductSetSpecialPriceRequestParam',
            'catalogProductSetSpecialPriceResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductSetSpecialPriceResponseParam',
            'catalogProductGetSpecialPriceRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductGetSpecialPriceRequestParam',
            'catalogProductGetSpecialPriceResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductGetSpecialPriceResponseParam',
            'catalogProductDeleteRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDeleteRequestParam',
            'catalogProductDeleteResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDeleteResponseParam',
            'catalogProductAttributeCurrentStoreRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeCurrentStoreRequestParam',
            'catalogProductAttributeCurrentStoreResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeCurrentStoreResponseParam',
            'catalogProductAttributeListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeListRequestParam',
            'catalogProductAttributeListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeListResponseParam',
            'catalogProductAttributeOptionsRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeOptionsRequestParam',
            'catalogProductAttributeOptionsResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeOptionsResponseParam',
            'catalogProductCustomOptionAddRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionAddRequestParam',
            'catalogProductCustomOptionAddResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionAddResponseParam',
            'catalogProductCustomOptionUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionUpdateRequestParam',
            'catalogProductCustomOptionUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionUpdateResponseParam',
            'catalogProductCustomOptionTypesRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionTypesRequestParam',
            'catalogProductCustomOptionTypesResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionTypesResponseParam',
            'catalogProductCustomOptionListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionListRequestParam',
            'catalogProductCustomOptionListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionListResponseParam',
            'catalogProductCustomOptionInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionInfoRequestParam',
            'catalogProductCustomOptionInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionInfoResponseParam',
            'catalogProductCustomOptionRemoveRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionRemoveRequestParam',
            'catalogProductCustomOptionRemoveResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionRemoveResponseParam',
            'catalogProductCustomOptionValueListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionValueListRequestParam',
            'catalogProductCustomOptionValueListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionValueListResponseParam',
            'catalogProductCustomOptionValueInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionValueInfoRequestParam',
            'catalogProductCustomOptionValueInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionValueInfoResponseParam',
            'catalogProductCustomOptionValueAddRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionValueAddRequestParam',
            'catalogProductCustomOptionValueAddResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionValueAddResponseParam',
            'catalogProductCustomOptionValueUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionValueUpdateRequestParam',
            'catalogProductCustomOptionValueUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionValueUpdateResponseParam',
            'catalogProductCustomOptionValueRemoveRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionValueRemoveRequestParam',
            'catalogProductCustomOptionValueRemoveResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductCustomOptionValueRemoveResponseParam',
            'catalogProductAttributeSetCreateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetCreateRequestParam',
            'catalogProductAttributeSetCreateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetCreateResponseParam',
            'catalogProductAttributeSetRemoveRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetRemoveRequestParam',
            'catalogProductAttributeSetRemoveResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetRemoveResponseParam',
            'catalogProductAttributeSetListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetListRequestParam',
            'catalogProductAttributeSetListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetListResponseParam',
            'catalogProductAttributeSetAttributeAddRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetAttributeAddRequestParam',
            'catalogProductAttributeSetAttributeAddResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetAttributeAddResponseParam',
            'catalogProductAttributeAddOptionRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeAddOptionRequestParam',
            'catalogProductAttributeAddOptionResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeAddOptionResponseParam',
            'catalogProductAttributeSetAttributeRemoveRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetAttributeRemoveRequestParam',
            'catalogProductAttributeSetAttributeRemoveResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetAttributeRemoveResponseParam',
            'catalogProductAttributeSetGroupAddRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetGroupAddRequestParam',
            'catalogProductAttributeSetGroupAddResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetGroupAddResponseParam',
            'catalogProductAttributeSetGroupRenameRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetGroupRenameRequestParam',
            'catalogProductAttributeSetGroupRenameResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetGroupRenameResponseParam',
            'catalogProductAttributeSetGroupRemoveRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetGroupRemoveRequestParam',
            'catalogProductAttributeSetGroupRemoveResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeSetGroupRemoveResponseParam',
            'catalogProductTypeListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTypeListRequestParam',
            'catalogProductTypeListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTypeListResponseParam',
            'catalogProductAttributeTierPriceInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeTierPriceInfoRequestParam',
            'catalogProductAttributeTierPriceInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeTierPriceInfoResponseParam',
            'catalogProductAttributeTierPriceUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeTierPriceUpdateRequestParam',
            'catalogProductAttributeTierPriceUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeTierPriceUpdateResponseParam',
            'catalogProductAttributeMediaCurrentStoreRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaCurrentStoreRequestParam',
            'catalogProductAttributeMediaCurrentStoreResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaCurrentStoreResponseParam',
            'catalogProductAttributeMediaListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaListRequestParam',
            'catalogProductAttributeMediaListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaListResponseParam',
            'catalogProductAttributeMediaInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaInfoRequestParam',
            'catalogProductAttributeMediaInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaInfoResponseParam',
            'catalogProductAttributeMediaTypesRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaTypesRequestParam',
            'catalogProductAttributeMediaTypesResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaTypesResponseParam',
            'catalogProductAttributeMediaCreateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaCreateRequestParam',
            'catalogProductAttributeMediaCreateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaCreateResponseParam',
            'catalogProductAttributeMediaUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaUpdateRequestParam',
            'catalogProductAttributeMediaUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaUpdateResponseParam',
            'catalogProductAttributeMediaRemoveRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaRemoveRequestParam',
            'catalogProductAttributeMediaRemoveResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeMediaRemoveResponseParam',
            'catalogProductLinkListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductLinkListRequestParam',
            'catalogProductLinkListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductLinkListResponseParam',
            'catalogProductLinkAssignRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductLinkAssignRequestParam',
            'catalogProductLinkAssignResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductLinkAssignResponseParam',
            'catalogProductLinkUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductLinkUpdateRequestParam',
            'catalogProductLinkUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductLinkUpdateResponseParam',
            'catalogProductLinkRemoveRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductLinkRemoveRequestParam',
            'catalogProductLinkRemoveResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductLinkRemoveResponseParam',
            'catalogProductLinkTypesRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductLinkTypesRequestParam',
            'catalogProductLinkTypesResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductLinkTypesResponseParam',
            'catalogProductLinkAttributesRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductLinkAttributesRequestParam',
            'catalogProductLinkAttributesResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductLinkAttributesResponseParam',
            'catalogCategoryCurrentStoreRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryCurrentStoreRequestParam',
            'catalogCategoryCurrentStoreResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryCurrentStoreResponseParam',
            'catalogCategoryTreeRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryTreeRequestParam',
            'catalogCategoryTreeResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryTreeResponseParam',
            'catalogCategoryLevelRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryLevelRequestParam',
            'catalogCategoryLevelResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryLevelResponseParam',
            'catalogCategoryInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryInfoRequestParam',
            'catalogCategoryInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryInfoResponseParam',
            'catalogCategoryCreateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryCreateRequestParam',
            'catalogCategoryCreateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryCreateResponseParam',
            'catalogCategoryUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryUpdateRequestParam',
            'catalogCategoryUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryUpdateResponseParam',
            'catalogCategoryMoveRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryMoveRequestParam',
            'catalogCategoryMoveResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryMoveResponseParam',
            'catalogCategoryDeleteRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryDeleteRequestParam',
            'catalogCategoryDeleteResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryDeleteResponseParam',
            'catalogCategoryAssignedProductsRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryAssignedProductsRequestParam',
            'catalogCategoryAssignedProductsResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryAssignedProductsResponseParam',
            'catalogCategoryAssignProductRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryAssignProductRequestParam',
            'catalogCategoryAssignProductResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryAssignProductResponseParam',
            'catalogCategoryUpdateProductRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryUpdateProductRequestParam',
            'catalogCategoryUpdateProductResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryUpdateProductResponseParam',
            'catalogCategoryRemoveProductRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryRemoveProductRequestParam',
            'catalogCategoryRemoveProductResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryRemoveProductResponseParam',
            'catalogCategoryAttributeListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryAttributeListRequestParam',
            'catalogCategoryAttributeListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryAttributeListResponseParam',
            'catalogCategoryAttributeOptionsRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryAttributeOptionsRequestParam',
            'catalogCategoryAttributeOptionsResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryAttributeOptionsResponseParam',
            'catalogCategoryAttributeCurrentStoreRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryAttributeCurrentStoreRequestParam',
            'catalogCategoryAttributeCurrentStoreResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogCategoryAttributeCurrentStoreResponseParam',
            'catalogProductAttributeCreateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeCreateRequestParam',
            'catalogProductAttributeCreateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeCreateResponseParam',
            'catalogProductAttributeRemoveRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeRemoveRequestParam',
            'catalogProductAttributeRemoveResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeRemoveResponseParam',
            'catalogProductAttributeInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeInfoRequestParam',
            'catalogProductAttributeInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeInfoResponseParam',
            'catalogProductAttributeUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeUpdateRequestParam',
            'catalogProductAttributeUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductAttributeUpdateResponseParam',
            'salesOrderEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderEntity',
            'salesOrderListEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderListEntity',
            'salesOrderListEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\SalesOrderListEntityArray',
            'salesOrderAddressEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderAddressEntity',
            'salesOrderItemEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderItemEntity',
            'salesOrderItemEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\SalesOrderItemEntityArray',
            'orderItemIdQty' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\OrderItemIdQty',
            'orderItemIdQtyArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\OrderItemIdQtyArray',
            'salesOrderPaymentEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderPaymentEntity',
            'salesOrderStatusHistoryEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderStatusHistoryEntity',
            'salesOrderStatusHistoryEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\SalesOrderStatusHistoryEntityArray',
            'salesOrderShipmentEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentEntity',
            'salesOrderShipmentEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\SalesOrderShipmentEntityArray',
            'salesOrderShipmentCommentEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentCommentEntity',
            'salesOrderShipmentCommentEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\SalesOrderShipmentCommentEntityArray',
            'salesOrderShipmentTrackEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentTrackEntity',
            'salesOrderShipmentTrackEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\SalesOrderShipmentTrackEntityArray',
            'salesOrderShipmentItemEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentItemEntity',
            'salesOrderShipmentItemEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\SalesOrderShipmentItemEntityArray',
            'salesOrderInvoiceEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceEntity',
            'salesOrderInvoiceEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\SalesOrderInvoiceEntityArray',
            'salesOrderInvoiceItemEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceItemEntity',
            'salesOrderInvoiceItemEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\SalesOrderInvoiceItemEntityArray',
            'salesOrderInvoiceCommentEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceCommentEntity',
            'salesOrderInvoiceCommentEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\SalesOrderInvoiceCommentEntityArray',
            'salesOrderCreditmemoEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCreditmemoEntity',
            'salesOrderCreditmemoEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\SalesOrderCreditmemoEntityArray',
            'salesOrderCreditmemoItemEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCreditmemoItemEntity',
            'salesOrderCreditmemoItemEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\SalesOrderCreditmemoItemEntityArray',
            'salesOrderCreditmemoCommentEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCreditmemoCommentEntity',
            'salesOrderCreditmemoCommentEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\SalesOrderCreditmemoCommentEntityArray',
            'salesOrderCreditmemoData' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCreditmemoData',
            'salesOrderListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderListRequestParam',
            'salesOrderListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderListResponseParam',
            'salesOrderInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInfoRequestParam',
            'salesOrderInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInfoResponseParam',
            'salesOrderAddCommentRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderAddCommentRequestParam',
            'salesOrderAddCommentResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderAddCommentResponseParam',
            'salesOrderHoldRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderHoldRequestParam',
            'salesOrderHoldResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderHoldResponseParam',
            'salesOrderUnholdRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderUnholdRequestParam',
            'salesOrderUnholdResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderUnholdResponseParam',
            'salesOrderCancelRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCancelRequestParam',
            'salesOrderCancelResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCancelResponseParam',
            'salesOrderShipmentListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentListRequestParam',
            'salesOrderShipmentListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentListResponseParam',
            'salesOrderShipmentInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentInfoRequestParam',
            'salesOrderShipmentInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentInfoResponseParam',
            'salesOrderShipmentCreateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentCreateRequestParam',
            'salesOrderShipmentCreateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentCreateResponseParam',
            'salesOrderShipmentAddTrackRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentAddTrackRequestParam',
            'salesOrderShipmentAddTrackResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentAddTrackResponseParam',
            'salesOrderShipmentRemoveTrackRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentRemoveTrackRequestParam',
            'salesOrderShipmentRemoveTrackResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentRemoveTrackResponseParam',
            'salesOrderShipmentSendInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentSendInfoRequestParam',
            'salesOrderShipmentSendInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentSendInfoResponseParam',
            'salesOrderShipmentAddCommentRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentAddCommentRequestParam',
            'salesOrderShipmentAddCommentResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentAddCommentResponseParam',
            'salesOrderShipmentGetCarriersRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentGetCarriersRequestParam',
            'salesOrderShipmentGetCarriersResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderShipmentGetCarriersResponseParam',
            'salesOrderInvoiceListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceListRequestParam',
            'salesOrderInvoiceListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceListResponseParam',
            'salesOrderInvoiceInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceInfoRequestParam',
            'salesOrderInvoiceInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceInfoResponseParam',
            'salesOrderInvoiceCreateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceCreateRequestParam',
            'salesOrderInvoiceCreateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceCreateResponseParam',
            'salesOrderInvoiceAddCommentRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceAddCommentRequestParam',
            'salesOrderInvoiceAddCommentResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceAddCommentResponseParam',
            'salesOrderInvoiceCaptureRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceCaptureRequestParam',
            'salesOrderInvoiceCaptureResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceCaptureResponseParam',
            'salesOrderInvoiceVoidRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceVoidRequestParam',
            'salesOrderInvoiceVoidResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceVoidResponseParam',
            'salesOrderInvoiceCancelRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceCancelRequestParam',
            'salesOrderInvoiceCancelResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderInvoiceCancelResponseParam',
            'salesOrderCreditmemoListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCreditmemoListRequestParam',
            'salesOrderCreditmemoListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCreditmemoListResponseParam',
            'salesOrderCreditmemoInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCreditmemoInfoRequestParam',
            'salesOrderCreditmemoInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCreditmemoInfoResponseParam',
            'salesOrderCreditmemoCreateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCreditmemoCreateRequestParam',
            'salesOrderCreditmemoCreateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCreditmemoCreateResponseParam',
            'salesOrderCreditmemoAddCommentRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCreditmemoAddCommentRequestParam',
            'salesOrderCreditmemoAddCommentResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCreditmemoAddCommentResponseParam',
            'salesOrderCreditmemoCancelRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCreditmemoCancelRequestParam',
            'salesOrderCreditmemoCancelResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\SalesOrderCreditmemoCancelResponseParam',
            'catalogInventoryStockItemEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogInventoryStockItemEntity',
            'catalogInventoryStockItemEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogInventoryStockItemEntityArray',
            'catalogInventoryStockItemUpdateEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogInventoryStockItemUpdateEntity',
            'catalogInventoryStockItemUpdateEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogInventoryStockItemUpdateEntityArray',
            'catalogInventoryStockItemListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogInventoryStockItemListRequestParam',
            'catalogInventoryStockItemListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogInventoryStockItemListResponseParam',
            'catalogInventoryStockItemUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogInventoryStockItemUpdateRequestParam',
            'catalogInventoryStockItemUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogInventoryStockItemUpdateResponseParam',
            'catalogInventoryStockItemMultiUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogInventoryStockItemMultiUpdateRequestParam',
            'catalogInventoryStockItemMultiUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogInventoryStockItemMultiUpdateResponseParam',
            'shoppingCartAddressEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartAddressEntity',
            'shoppingCartItemEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartItemEntity',
            'shoppingCartItemEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ShoppingCartItemEntityArray',
            'shoppingCartPaymentEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartPaymentEntity',
            'shoppingCartInfoEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartInfoEntity',
            'shoppingCartTotalsEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartTotalsEntity',
            'shoppingCartTotalsEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ShoppingCartTotalsEntityArray',
            'shoppingCartLicenseEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartLicenseEntity',
            'shoppingCartLicenseEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ShoppingCartLicenseEntityArray',
            'shoppingCartProductEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartProductEntity',
            'shoppingCartProductEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ShoppingCartProductEntityArray',
            'shoppingCartProductResponseEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ShoppingCartProductResponseEntityArray',
            'shoppingCartCustomerEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartCustomerEntity',
            'shoppingCartCustomerAddressEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartCustomerAddressEntity',
            'shoppingCartCustomerAddressEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ShoppingCartCustomerAddressEntityArray',
            'shoppingCartShippingMethodEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartShippingMethodEntity',
            'shoppingCartShippingMethodEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ShoppingCartShippingMethodEntityArray',
            'shoppingCartPaymentMethodEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartPaymentMethodEntity',
            'shoppingCartPaymentMethodResponseEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartPaymentMethodResponseEntity',
            'shoppingCartPaymentMethodResponseEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\ShoppingCartPaymentMethodResponseEntityArray',
            'shoppingCartCreateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartCreateRequestParam',
            'shoppingCartCreateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartCreateResponseParam',
            'shoppingCartOrderRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartOrderRequestParam',
            'shoppingCartOrderResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartOrderResponseParam',
            'shoppingCartInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartInfoRequestParam',
            'shoppingCartInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartInfoResponseParam',
            'shoppingCartTotalsRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartTotalsRequestParam',
            'shoppingCartTotalsResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartTotalsResponseParam',
            'shoppingCartLicenseRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartLicenseRequestParam',
            'shoppingCartLicenseResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartLicenseResponseParam',
            'shoppingCartProductAddRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartProductAddRequestParam',
            'shoppingCartProductAddResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartProductAddResponseParam',
            'shoppingCartProductUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartProductUpdateRequestParam',
            'shoppingCartProductUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartProductUpdateResponseParam',
            'shoppingCartProductRemoveRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartProductRemoveRequestParam',
            'shoppingCartProductRemoveResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartProductRemoveResponseParam',
            'shoppingCartProductListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartProductListRequestParam',
            'shoppingCartProductListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartProductListResponseParam',
            'shoppingCartProductMoveToCustomerQuoteRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartProductMoveToCustomerQuoteRequestParam',
            'shoppingCartProductMoveToCustomerQuoteResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartProductMoveToCustomerQuoteResponseParam',
            'shoppingCartCustomerSetRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartCustomerSetRequestParam',
            'shoppingCartCustomerSetResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartCustomerSetResponseParam',
            'shoppingCartCustomerAddressesRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartCustomerAddressesRequestParam',
            'shoppingCartCustomerAddressesResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartCustomerAddressesResponseParam',
            'shoppingCartShippingMethodRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartShippingMethodRequestParam',
            'shoppingCartShippingMethodResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartShippingMethodResponseParam',
            'shoppingCartShippingListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartShippingListRequestParam',
            'shoppingCartShippingListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartShippingListResponseParam',
            'shoppingCartPaymentMethodRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartPaymentMethodRequestParam',
            'shoppingCartPaymentMethodResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartPaymentMethodResponseParam',
            'shoppingCartPaymentListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartPaymentListRequestParam',
            'shoppingCartPaymentListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartPaymentListResponseParam',
            'shoppingCartCouponAddRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartCouponAddRequestParam',
            'shoppingCartCouponAddResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartCouponAddResponseParam',
            'shoppingCartCouponRemoveRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartCouponRemoveRequestParam',
            'shoppingCartCouponRemoveResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\ShoppingCartCouponRemoveResponseParam',
            'catalogProductTagListEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTagListEntity',
            'catalogProductTagListEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductTagListEntityArray',
            'catalogProductTagAddEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTagAddEntity',
            'catalogProductTagUpdateEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTagUpdateEntity',
            'catalogProductTagInfoEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTagInfoEntity',
            'catalogProductTagListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTagListRequestParam',
            'catalogProductTagListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTagListResponseParam',
            'catalogProductTagInfoRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTagInfoRequestParam',
            'catalogProductTagInfoResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTagInfoResponseParam',
            'catalogProductTagAddRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTagAddRequestParam',
            'catalogProductTagAddResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTagAddResponseParam',
            'catalogProductTagUpdateRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTagUpdateRequestParam',
            'catalogProductTagUpdateResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTagUpdateResponseParam',
            'catalogProductTagRemoveRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTagRemoveRequestParam',
            'catalogProductTagRemoveResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductTagRemoveResponseParam',
            'giftMessageEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\GiftMessageEntity',
            'giftMessageResponse' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\GiftMessageResponse',
            'giftMessageResponseArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\GiftMessageResponseArray',
            'giftMessageAssociativeProductsEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\GiftMessageAssociativeProductsEntity',
            'giftMessageAssociativeProductsEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\GiftMessageAssociativeProductsEntityArray',
            'giftMessageForQuoteRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\GiftMessageForQuoteRequestParam',
            'giftMessageForQuoteResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\GiftMessageForQuoteResponseParam',
            'giftMessageForQuoteItemRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\GiftMessageForQuoteItemRequestParam',
            'giftMessageForQuoteItemResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\GiftMessageForQuoteItemResponseParam',
            'giftMessageForQuoteProductRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\GiftMessageForQuoteProductRequestParam',
            'giftMessageForQuoteProductResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\GiftMessageForQuoteProductResponseParam',
            'catalogProductDownloadableLinkFileEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDownloadableLinkFileEntity',
            'catalogProductDownloadableLinkAddSampleEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDownloadableLinkAddSampleEntity',
            'catalogProductDownloadableLinkAddEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDownloadableLinkAddEntity',
            'catalogProductDownloadableLinkFileInfoEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDownloadableLinkFileInfoEntity',
            'catalogProductDownloadableLinkFileInfoEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductDownloadableLinkFileInfoEntityArray',
            'catalogProductDownloadableLinkEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDownloadableLinkEntity',
            'catalogProductDownloadableLinkEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductDownloadableLinkEntityArray',
            'catalogProductDownloadableLinkSampleEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDownloadableLinkSampleEntity',
            'catalogProductDownloadableLinkSampleEntityArray' => '\\App\\Api\\Client\\Magento\\Type\\ArrayType\\CatalogProductDownloadableLinkSampleEntityArray',
            'catalogProductDownloadableLinkListEntity' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDownloadableLinkListEntity',
            'catalogProductDownloadableLinkAddRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDownloadableLinkAddRequestParam',
            'catalogProductDownloadableLinkAddResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDownloadableLinkAddResponseParam',
            'catalogProductDownloadableLinkListRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDownloadableLinkListRequestParam',
            'catalogProductDownloadableLinkListResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDownloadableLinkListResponseParam',
            'catalogProductDownloadableLinkRemoveRequestParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDownloadableLinkRemoveRequestParam',
            'catalogProductDownloadableLinkRemoveResponseParam' => '\\App\\Api\\Client\\Magento\\Type\\StructType\\CatalogProductDownloadableLinkRemoveResponseParam',
        );
    }
}
