<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveRequest StructType
 * @subpackage Structs
 * @Authors Georgi Georgiev, Rihards @dExIT@ Mantejs
 * @Version 0.1
 * @Date 14/06/2018
 */
class SaveRequest extends AbstractStructBase
{
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Action;
    /**
     * The TemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateName;
    /**
     * The CsvData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CsvData;
    /**
     * Constructor method for SaveRequest
     * @uses SaveRequest::setAction()
     * @uses SaveRequest::setTemplateName()
     * @uses SaveRequest::setCsvData()
     * @param int $action
     * @param string $templateName
     * @param string $csvData
     */
    public function __construct($action = null, $templateName = null, $csvData = null)
    {
        $this
            ->setAction($action)
            ->setTemplateName($templateName)
            ->setCsvData($csvData);
    }
    /**
     * Get Action value
     * @return int
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param int $action
     * @return \StructType\SaveRequest
     */
    public function setAction($action = null)
    {
        // validation for constraint: int
        if (!is_null($action) && !is_numeric($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($action)), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get TemplateName value
     * @return string|null
     */
    public function getTemplateName()
    {
        return $this->TemplateName;
    }
    /**
     * Set TemplateName value
     * @param string $templateName
     * @return \StructType\SaveRequest
     */
    public function setTemplateName($templateName = null)
    {
        // validation for constraint: string
        if (!is_null($templateName) && !is_string($templateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($templateName)), __LINE__);
        }
        $this->TemplateName = $templateName;
        return $this;
    }
    /**
     * Get CsvData value
     * @return string|null
     */
    public function getCsvData()
    {
        return $this->CsvData;
    }
    /**
     * Set CsvData value
     * @param string $csvData
     * @return \StructType\SaveRequest
     */
    public function setCsvData($csvData = null)
    {
        // validation for constraint: string
        if (!is_null($csvData) && !is_string($csvData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($csvData)), __LINE__);
        }
        $this->CsvData = $csvData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaveRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
